/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Vector;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RFileOutputStream;

public class RUtils {
    public static void installRScript(String sourcePath, String targetName, RConnection rconnection) throws Exception {
        RUtils.copyFileToServer(sourcePath, targetName, rconnection);
        rconnection.voidEval("source(\"" + targetName + "\")");
    }

    public static void copyFileToServer(File source, String targetName, RConnection rconnection) throws Exception {
        if (!source.exists()) {
            throw new IOException("\"" + source.getAbsolutePath() + "\" does not exit.");
        }
        if (!source.isFile()) {
            throw new IOException("The source has o be a file.");
        }
        if (!source.canRead()) {
            throw new IOException("Can't read the source file.");
        }
        RFileOutputStream os = rconnection.createFile(targetName);
        PrintStream ps = new PrintStream((OutputStream)os);
        FileInputStream fileInputStream = new FileInputStream(source);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String line = bufferedReader.readLine();
        if (line != null) {
            while (line != null) {
                ps.println(line);
                line = bufferedReader.readLine();
            }
        }
        bufferedReader.close();
        fileInputStream.close();
        ps.close();
    }

    public static void copyFileToServer(String sourcePath, String targetName, RConnection rconnection) throws Exception {
        RUtils.copyFileToServer(new File(sourcePath), targetName, rconnection);
    }

    public static int copyFileFromServer(String sourcePath, String targetPath, RConnection c) throws Exception {
        byte[] b = RUtils.getBytesFromFileOnServer(sourcePath, c);
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(targetPath)), b.length);
        bw.write(new String(b));
        bw.close();
        return b.length;
    }

    protected static byte[] getBytesFromFileOnServer(String sourcePath, RConnection c) throws Exception {
        int n;
        RFileInputStream is = c.openFile(sourcePath);
        Vector<byte[]> buffers = new Vector<byte[]>();
        int bufSize = 65536;
        int imgPos = 0;
        byte[] buf = new byte[bufSize];
        while ((n = is.read(buf)) == bufSize) {
            buffers.addElement(buf);
            buf = new byte[bufSize];
            ++imgPos;
        }
        imgPos *= bufSize;
        if (n > 0 && n < bufSize) {
            imgPos += n;
        }
        byte[] code = new byte[imgPos];
        imgPos = 0;
        Enumeration e = buffers.elements();
        while (e.hasMoreElements()) {
            byte[] b = (byte[])e.nextElement();
            System.arraycopy(b, 0, code, imgPos, bufSize);
            imgPos += bufSize;
        }
        if (n > 0) {
            System.arraycopy(buf, 0, code, imgPos, n);
        }
        return code;
    }

    public static RConnection openRConnection(String rServeHostName, String loginName, String passwd) throws Exception {
        RConnection c = new RConnection(rServeHostName);
        if (c.needLogin()) {
            c.login(loginName, passwd);
        }
        return c;
    }
}

