/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels;

import de.jstacs.InstantiableFromParameterSet;
import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.TopSort;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.ParameterSetParser;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.InstanceParameterSet;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.scoringFunctions.directedGraphicalModels.BayesianNetworkScoringFunctionParameterSet;
import de.jstacs.scoringFunctions.directedGraphicalModels.Parameter;
import de.jstacs.scoringFunctions.directedGraphicalModels.ParameterTree;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.InhomogeneousMarkov;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class BayesianNetworkScoringFunction
extends AbstractNormalizableScoringFunction
implements InstantiableFromParameterSet {
    protected Parameter[] parameters;
    protected ParameterTree[] trees;
    protected boolean isTrained;
    protected double ess;
    protected Integer numFreePars;
    protected int[] nums;
    protected Measure structureMeasure;
    protected boolean plugInParameters;
    protected int[][] order;
    protected Double normalizationConstant;
    private int[] roots;
    private boolean freeParams;
    private Double gammaNorm;
    private BayesianNetworkScoringFunctionParameterSet parameterSet;

    public BayesianNetworkScoringFunction(AlphabetContainer alphabet, int length, double ess, boolean plugInParameters, Measure structureMeasure) throws Exception {
        super(alphabet, length);
        if (!alphabet.isDiscrete()) {
            throw new Exception("Only defined on discrete alphabets.");
        }
        if (length <= 0) {
            throw new Exception("Inconsistent length (" + length + ").");
        }
        this.isTrained = false;
        this.ess = ess;
        this.plugInParameters = plugInParameters;
        this.structureMeasure = structureMeasure;
        this.normalizationConstant = null;
    }

    public BayesianNetworkScoringFunction(BayesianNetworkScoringFunctionParameterSet parameters) throws ParameterSetParser.NotInstantiableException, Exception {
        this(parameters.getAlphabet(), parameters.getLength(), parameters.getEss(), parameters.getPlugInParameters(), parameters.getMeasure());
        this.parameterSet = parameters;
    }

    public BayesianNetworkScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.normalizationConstant = null;
        this.gammaNorm = null;
    }

    public BayesianNetworkScoringFunction clone() throws CloneNotSupportedException {
        BayesianNetworkScoringFunction clone = (BayesianNetworkScoringFunction)super.clone();
        if (this.trees != null) {
            clone.trees = new ParameterTree[this.trees.length];
            for (int i = 0; i < this.trees.length; ++i) {
                clone.trees[i] = this.trees[i].clone();
            }
            LinkedList[] parTemp = new LinkedList[this.trees.length];
            int num = 0;
            for (int i = 0; i < clone.trees.length; ++i) {
                parTemp[i] = clone.trees[i].linearizeParameters();
                num += parTemp[i].size();
            }
            clone.parameters = new Parameter[num];
            num = 0;
            Iterator it = null;
            for (int i = 0; i < parTemp.length; ++i) {
                it = parTemp[i].iterator();
                while (it.hasNext()) {
                    clone.parameters[num++] = (Parameter)it.next();
                }
            }
            clone.nums = (int[])this.nums.clone();
        } else {
            clone.trees = null;
            clone.nums = null;
            clone.parameters = null;
        }
        clone.structureMeasure = this.structureMeasure.clone();
        clone.normalizationConstant = null;
        return clone;
    }

    public double getPartialNormalizationConstant(int parameterIndex) throws Exception {
        if (this.normalizationConstant == null) {
            this.precomputeNormalization();
        }
        if (parameterIndex < this.nums.length) {
            Parameter p = this.parameters[this.nums[parameterIndex]];
            int pos = p.getPosition();
            boolean[] notRoot = new boolean[this.trees.length];
            for (int i = 0; i < this.trees.length; ++i) {
                if (this.trees[i].getNumberOfParents() <= 0) continue;
                notRoot[i] = true;
            }
            double val = p.getPartialNormalizer();
            for (int i = 0; i < notRoot.length; ++i) {
                if (notRoot[i] || i == this.roots[pos]) continue;
                val *= this.trees[i].forward(this.trees);
            }
            return val;
        }
        throw new Exception("Parameter index out of bounds");
    }

    private int[][] getFirstChildrenAndFirstParents(int[][] parents) throws Exception {
        int j;
        int i;
        LinkedList[] fc = new LinkedList[parents.length];
        boolean test = false;
        int i2 = 0;
        while (i2 < fc.length) {
            fc[i2++] = new LinkedList();
        }
        int[][] erg = new int[parents.length + 1][];
        erg[parents.length] = new int[parents.length];
        Arrays.fill(erg[parents.length], -1);
        for (i = 0; i < parents.length; ++i) {
            test = parents[i].length < 2;
            for (j = 0; j < parents[i].length - 1; ++j) {
                if (!this.testInclude(parents[i], parents[parents[i][j]])) continue;
                fc[parents[i][j]].add(i);
                erg[parents.length][i] = parents[i][j];
                test = true;
            }
            if (test) continue;
            throw new Exception("Structure is no moral graph!");
        }
        for (i = 0; i < fc.length; ++i) {
            erg[i] = new int[fc[i].size()];
            for (j = 0; j < erg[i].length; ++j) {
                erg[i][j] = (Integer)fc[i].poll();
            }
        }
        return erg;
    }

    private boolean testInclude(int[] parentsOfChild, int[] parentsOfParent) {
        for (int i = 0; i < parentsOfChild.length - 1; ++i) {
            boolean found = false;
            for (int j = 0; j < parentsOfParent.length; ++j) {
                if (parentsOfChild[i] != parentsOfParent[j]) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        if (data[index] != null && data[index].getElementLength() != this.length) {
            throw new Exception("Data has wrong length.");
        }
        this.freeParams = freeParams;
        if (weights == null) {
            weights = new double[data.length][];
            for (int i = 0; i < data.length; ++i) {
                weights[i] = new double[data[i].getNumberOfElements()];
                Arrays.fill(weights[i], 1.0);
            }
        }
        Sample[] data2 = data;
        Object weights2 = weights;
        if (data.length != 2) {
            data2 = new Sample[2];
            weights2 = new double[2][];
            data2[0] = data[index];
            weights2[0] = weights[index];
            boolean[] in = new boolean[data.length];
            Arrays.fill(in, true);
            in[index] = false;
            data2[1] = Sample.union(data, in);
            if (data2[1] != null) {
                weights2[1] = new double[data2[1].getNumberOfElements()];
                int off = 0;
                for (int i = 0; i < ((double[][])weights).length; ++i) {
                    if (!in[i]) continue;
                    System.arraycopy(weights[i], 0, weights2[1], off, weights[i].length);
                    off += weights[i].length;
                }
            } else {
                weights2[1] = null;
            }
        }
        this.createTrees(data2, (double[][])weights2);
        if (this.plugInParameters) {
            this.setPlugInParameters(index, freeParams, data, (double[][])weights);
        } else {
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i].setValue(-Math.log(this.alphabets.getAlphabetLengthAt(this.parameters[i].position)));
            }
        }
        this.isTrained = true;
        this.normalizationConstant = null;
    }

    protected void createTrees(Sample[] data2, double[][] weights2) throws Exception {
        int i;
        int[][] parents = this.structureMeasure.getParents(data2[0], data2[1], weights2[0], weights2[1], this.getLength());
        this.order = TopSort.getTopologicalOrder(parents);
        int[][] firstChildrenAndFirstParents = this.getFirstChildrenAndFirstParents(parents);
        this.numFreePars = 0;
        int numPars = 0;
        int[] numContextsPos = new int[this.getLength()];
        this.trees = new ParameterTree[this.getLength()];
        int numContexts = 0;
        int[] contextPoss = null;
        for (int i2 = 0; i2 < parents.length; ++i2) {
            int j;
            numContextsPos[i2] = 1;
            for (j = 0; j < parents[i2].length - 1; ++j) {
                int n = i2;
                numContextsPos[n] = (int)((double)numContextsPos[n] * this.alphabets.getAlphabetLengthAt(parents[i2][j]));
            }
            this.numFreePars = this.numFreePars + numContextsPos[i2] * ((int)this.getAlphabetContainer().getAlphabetLengthAt(i2) - 1);
            numPars = (int)((double)numPars + (double)numContextsPos[i2] * this.getAlphabetContainer().getAlphabetLengthAt(i2));
            numContexts += numContextsPos[i2];
            contextPoss = new int[parents[i2].length - 1];
            for (j = 0; j < contextPoss.length; ++j) {
                contextPoss[j] = parents[i2][parents[i2].length - j - 2];
            }
            this.trees[i2] = new ParameterTree(i2, contextPoss, this.getAlphabetContainer(), firstChildrenAndFirstParents[parents.length][i2], firstChildrenAndFirstParents[i2]);
        }
        this.parameters = new Parameter[numPars];
        if (!this.freeParams) {
            this.numFreePars = numPars;
        }
        this.nums = new int[this.numFreePars.intValue()];
        int curr = 0;
        int free = 0;
        int[][][][] contexts = new int[this.getLength()][][][];
        for (i = 0; i < parents.length; ++i) {
            contexts[i] = new int[numContextsPos[i]][parents[i].length - 1][];
            this.fillContexts(0, contexts[i], 0, parents[i]);
            for (int j = 0; j < contexts[i].length; ++j) {
                int all = 1;
                int act = 1;
                for (int k = 0; k < contexts[i][j].length; ++k) {
                    all = (int)((double)all * this.getAlphabetContainer().getAlphabetLengthAt(contexts[i][j][k][0]));
                    act *= contexts[i][j][k].length - 1;
                }
                byte a = 0;
                while ((double)a < this.getAlphabetContainer().getAlphabetLengthAt(i)) {
                    this.parameters[curr] = (double)a < this.getAlphabetContainer().getAlphabetLengthAt(i) - 1.0 || !this.freeParams ? new Parameter(free, a, i, contexts[i][j], (double)act * this.ess / ((double)all * this.getAlphabetContainer().getAlphabetLengthAt(i)), true) : new Parameter(-1, a, i, contexts[i][j], (double)act * this.ess / ((double)all * this.getAlphabetContainer().getAlphabetLengthAt(i)), false);
                    this.trees[i].setParameterFor(a, contexts[i][j], this.parameters[curr]);
                    if (this.parameters[curr].isFree()) {
                        this.nums[free++] = curr;
                    }
                    ++curr;
                    a = (byte)(a + 1);
                }
            }
        }
        this.roots = new int[this.trees.length];
        for (i = 0; i < this.trees.length; ++i) {
            int fp = i;
            while (this.trees[fp].getFirstParent() != -1) {
                fp = this.trees[fp].getFirstParent();
            }
            this.roots[i] = fp;
        }
        this.normalizationConstant = null;
        this.gammaNorm = null;
    }

    protected void setPlugInParameters(int index, boolean freeParameters, Sample[] data, double[][] weights) {
        if (data[index] != null) {
            int i;
            for (i = 0; i < data[index].getNumberOfElements(); ++i) {
                for (int j = 0; j < this.trees.length; ++j) {
                    this.trees[j].addCount(data[index].getElementAt(i), 0, weights[index][i]);
                }
            }
            for (i = 0; i < this.trees.length; ++i) {
                this.trees[i].normalizePlugInParameters();
                if (!freeParameters) continue;
                this.trees[i].divideByUnfree();
            }
        }
    }

    private int fillContexts(int offset, int[][][] contexts, int depth, int[] parents) {
        int tempOffset = offset;
        if (depth < parents.length - 1) {
            int i = 0;
            while ((double)i < this.alphabets.getAlphabetLengthAt(parents[parents.length - depth - 2])) {
                offset = tempOffset;
                tempOffset = this.fillContexts(offset, contexts, depth + 1, parents);
                for (int j = offset; j < tempOffset; ++j) {
                    contexts[j][depth] = new int[]{parents[parents.length - depth - 2], i};
                }
                ++i;
            }
            return tempOffset;
        }
        return offset + 1;
    }

    protected void fromXML(StringBuffer source) throws NonParsableException {
        source = XMLParser.extractForTag(source, "bayesianNetworkSF");
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(source, "alphabets");
        this.length = XMLParser.extractIntForTag(source, "length");
        this.trees = ParameterTree.fromStringArray(XMLParser.extractStringArrayForTag(source, "trees"), this.alphabets);
        if (this.trees.length == 0) {
            this.trees = null;
            this.parameters = null;
        } else {
            LinkedList[] parTemp = new LinkedList[this.trees.length];
            int num = 0;
            for (int i = 0; i < this.trees.length; ++i) {
                parTemp[i] = this.trees[i].linearizeParameters();
                num += parTemp[i].size();
            }
            this.parameters = new Parameter[num];
            num = 0;
            Iterator it = null;
            for (int i = 0; i < parTemp.length; ++i) {
                it = parTemp[i].iterator();
                while (it.hasNext()) {
                    this.parameters[num++] = (Parameter)it.next();
                }
            }
        }
        this.isTrained = XMLParser.extractBooleanForTag(source, "isTrained");
        this.ess = XMLParser.extractDoubleForTag(source, "ess");
        String numFreeParsTemp = XMLParser.extractStringForTag(source, "numFreePars");
        this.numFreePars = numFreeParsTemp.equals("null") ? null : Integer.valueOf(Integer.parseInt(numFreeParsTemp));
        this.nums = XMLParser.extractIntArrayForTag(source, "nums");
        if (this.nums.length == 0) {
            this.nums = null;
        }
        this.structureMeasure = (Measure)XMLParser.extractStorableForTag(source, "structureMeasure");
        this.order = XMLParser.extractInt2ArrayForTag(source, "order");
        if (this.order.length == 0) {
            this.order = null;
        }
        this.plugInParameters = XMLParser.extractBooleanForTag(source, "plugInParameters");
        this.roots = XMLParser.extractIntArrayForTag(source, "roots");
        if (this.roots.length == 0) {
            this.roots = null;
        }
        this.freeParams = XMLParser.extractBooleanForTag(source, "freeParams");
    }

    public String toString() {
        if (this.trees != null) {
            if (this.normalizationConstant == null) {
                this.precomputeNormalization();
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.trees.length; ++i) {
                buf.append(this.trees[i].toString());
                buf.append("\n");
            }
            return buf.toString();
        }
        return "BNScoringFunction of length " + this.length + ": not initialized";
    }

    public String getInstanceName() {
        return this.structureMeasure.getInstanceName();
    }

    public double getLogScore(Sequence seq, int start) {
        double prob = 0.0;
        for (int i = 0; i < this.trees.length; ++i) {
            prob += this.trees[i].getParameterFor(seq, start).getValue();
        }
        return prob;
    }

    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double logScore = 0.0;
        for (int i = 0; i < this.trees.length; ++i) {
            Parameter par = this.trees[i].getParameterFor(seq, start);
            if (par.isFree()) {
                indices.add(par.getIndex());
                partialDer.add(1.0);
            }
            logScore += par.getValue();
        }
        return logScore;
    }

    public double getNormalizationConstant() throws RuntimeException {
        if (this.normalizationConstant == null) {
            this.precomputeNormalization();
        }
        return this.normalizationConstant;
    }

    public int getNumberOfParameters() {
        if (this.nums == null) {
            return -1;
        }
        return this.nums.length;
    }

    public void setParameters(double[] params, int start) {
        for (int i = 0; i < this.nums.length; ++i) {
            this.parameters[this.nums[i]].setValue(params[i + start]);
        }
        this.normalizationConstant = null;
    }

    protected void precomputeNormalization() {
        int i;
        boolean[] notRoot = new boolean[this.trees.length];
        for (i = 0; i < this.trees.length; ++i) {
            this.trees[i].invalidateNormalizers();
        }
        for (i = 0; i < this.trees.length; ++i) {
            if (this.trees[i].getNumberOfParents() > 0) {
                notRoot[i] = true;
            }
            if (!this.trees[i].isLeaf()) continue;
            this.trees[i].backward(this.trees, this.order);
        }
        double val = 1.0;
        for (int i2 = 0; i2 < notRoot.length; ++i2) {
            if (notRoot[i2]) continue;
            val *= this.trees[i2].forward(this.trees);
        }
        this.normalizationConstant = val;
    }

    public double[] getCurrentParameterValues() throws Exception {
        double[] pars = new double[this.nums.length];
        for (int i = 0; i < pars.length; ++i) {
            pars[i] = this.parameters[this.nums[i]].getValue();
        }
        return pars;
    }

    public StringBuffer toXML() {
        StringBuffer source = new StringBuffer();
        XMLParser.appendStorableWithTags(source, this.alphabets, "alphabets");
        XMLParser.appendIntWithTags(source, this.length, "length");
        if (this.trees == null) {
            XMLParser.appendStringArrayWithTags(source, new String[0], "trees");
        } else {
            XMLParser.appendStringArrayWithTags(source, ParameterTree.toStringArray(this.trees), "trees");
        }
        XMLParser.appendBooleanWithTags(source, this.isTrained, "isTrained");
        XMLParser.appendDoubleWithTags(source, this.ess, "ess");
        if (this.numFreePars == null) {
            XMLParser.appendStringWithTags(source, "null", "numFreePars");
        } else {
            XMLParser.appendIntWithTags(source, this.numFreePars, "numFreePars");
        }
        if (this.nums == null) {
            XMLParser.appendIntArrayWithTags(source, new int[0], "nums");
        } else {
            XMLParser.appendIntArrayWithTags(source, this.nums, "nums");
        }
        XMLParser.appendStorableWithTags(source, this.structureMeasure, "structureMeasure");
        XMLParser.appendBooleanWithTags(source, this.plugInParameters, "plugInParameters");
        if (this.order == null) {
            XMLParser.appendInt2ArrayWithTags(source, new int[0][0], "order");
        } else {
            XMLParser.appendInt2ArrayWithTags(source, this.order, "order");
        }
        if (this.roots == null) {
            XMLParser.appendIntArrayWithTags(source, new int[0], "roots");
        } else {
            XMLParser.appendIntArrayWithTags(source, this.roots, "roots");
        }
        XMLParser.appendBooleanWithTags(source, this.freeParams, "freeParams");
        XMLParser.addTags(source, "bayesianNetworkSF");
        return source;
    }

    public double getLogPriorTerm() {
        if (this.gammaNorm == null) {
            this.computeGammaNorm();
        }
        double val = 0.0;
        for (int i = 0; i < this.nums.length; ++i) {
            val += this.parameters[this.nums[i]].getValue() * this.parameters[this.nums[i]].getPseudoCount();
        }
        return val + this.gammaNorm;
    }

    private void computeGammaNorm() {
        this.gammaNorm = 0.0;
        for (int i = 0; i < this.trees.length; ++i) {
            this.gammaNorm = this.gammaNorm + this.trees[i].computeGammaNorm();
        }
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) {
        for (int i = 0; i < this.nums.length; ++i) {
            int n = i + start;
            grad[n] = grad[n] + this.parameters[this.nums[i]].getPseudoCount();
        }
    }

    public double getEss() {
        return this.ess;
    }

    public int getPositionForParameter(int index) {
        return this.parameters[this.nums[index]].getPosition();
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        Parameter par = this.parameters[this.nums[index]];
        int size = (int)this.alphabets.getAlphabetLengthAt(par.getPosition());
        int[][] cont = par.context;
        for (int i = 0; i < cont.length; ++i) {
            size = (int)((double)size * this.alphabets.getAlphabetLengthAt(cont[i][0]));
        }
        return size;
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        if (!(this.structureMeasure instanceof InhomogeneousMarkov)) {
            throw new Exception("Not implemented");
        }
        this.freeParams = freeParams;
        boolean temp = this.plugInParameters;
        this.plugInParameters = false;
        this.initializeFunction(0, freeParams, new Sample[]{null, null}, new double[][]{null, null});
        this.plugInParameters = temp;
        for (int i = 0; i < this.trees.length; ++i) {
            this.trees[i].initializeRandomly(this.ess);
        }
    }

    public boolean isInitialized() {
        return this.trees != null;
    }

    public double[][] getPWM() throws Exception {
        if (!(this.structureMeasure instanceof InhomogeneousMarkov)) {
            throw new Exception();
        }
        if (this.normalizationConstant == null) {
            this.precomputeNormalization();
        }
        double[][] pwm = new double[this.trees.length][];
        for (int i = 0; i < this.trees.length; ++i) {
            pwm[i] = new double[(int)this.alphabets.getAlphabetLengthAt(i)];
            this.trees[i].insertProbs(pwm[i]);
        }
        return pwm;
    }

    public InstanceParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameterSet != null) {
            return this.parameterSet;
        }
        return new BayesianNetworkScoringFunctionParameterSet(this.getAlphabetContainer(), this.getLength(), this.ess, this.plugInParameters, this.structureMeasure);
    }
}

