/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.VariableLengthScoringFunction;
import de.jstacs.scoringFunctions.mix.AbstractMixtureScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;

public class IndependentProductScoringFunction
extends AbstractNormalizableScoringFunction
implements MutableMotifDiscoverer {
    private NormalizableScoringFunction[] score;
    private int[] start;
    private int[] partialLength;
    private int[] params;
    private int[] motifs;
    private int[] motifIndexArray;
    private int[] components;
    private int[] componentIndexArray;
    private boolean[] isVariable;
    private IntList partIList;

    private static final AlphabetContainer getAlphabetContainer(NormalizableScoringFunction[] functions, int[] length) throws IllegalArgumentException {
        AlphabetContainer[] cons = new AlphabetContainer[functions.length];
        int[] lengths = new int[functions.length];
        for (int i = 0; i < functions.length; ++i) {
            cons[i] = functions[i].getAlphabetContainer();
            lengths[i] = length[i];
        }
        return new AlphabetContainer(cons, lengths);
    }

    private static final int sum(int[] length) throws IllegalArgumentException {
        int res = 0;
        int i = 0;
        while (i < length.length && length[i] > 0) {
            res += length[i++];
        }
        if (i != length.length) {
            throw new IllegalArgumentException("The length with index " + i + " is 0.");
        }
        return res;
    }

    private static final int[] getLengthArray(NormalizableScoringFunction ... functions) throws IllegalArgumentException {
        int i;
        int[] res = new int[functions.length];
        for (i = 0; i < functions.length && functions[i].getLength() > 0; ++i) {
            res[i] = functions[i].getLength();
        }
        if (i != functions.length) {
            throw new IllegalArgumentException("The NormalizableScoringFunction with index " + i + " has a length 0.");
        }
        return res;
    }

    public IndependentProductScoringFunction(NormalizableScoringFunction ... functions) throws CloneNotSupportedException, IllegalArgumentException {
        this(functions, IndependentProductScoringFunction.getLengthArray(functions));
    }

    public IndependentProductScoringFunction(NormalizableScoringFunction[] functions, int[] length) throws CloneNotSupportedException, IllegalArgumentException {
        super(IndependentProductScoringFunction.getAlphabetContainer(functions, length), IndependentProductScoringFunction.sum(length));
        int i;
        this.score = (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])functions);
        this.setStartsAndLengths(length);
        this.setParamsStarts();
        double ess = this.score[0].getEss();
        for (i = 1; i < this.score.length && this.score[i].getEss() == ess; ++i) {
        }
        if (i != this.score.length) {
            throw new IllegalArgumentException("All NormalizableScoringFunction have to use the same ESS. Violated at index " + i + ".");
        }
        this.prepare();
    }

    private void prepare() {
        this.motifs = new int[this.score.length + 1];
        this.components = new int[this.score.length];
        int c = 1;
        for (int i = 0; i < this.score.length; ++i) {
            this.motifs[i + 1] = this.motifs[i];
            if (this.score[i] instanceof MotifDiscoverer) {
                int n = i + 1;
                this.motifs[n] = this.motifs[n] + ((MotifDiscoverer)((Object)this.score[i])).getNumberOfMotifs();
            }
            this.components[i] = c;
            if (this.score[i] instanceof AbstractMixtureScoringFunction) {
                int n = i;
                this.components[n] = this.components[n] * ((AbstractMixtureScoringFunction)this.score[i]).getNumberOfComponents();
                continue;
            }
            if (!(this.score[i] instanceof MotifDiscoverer)) continue;
            int n = i;
            this.components[n] = this.components[n] * ((MotifDiscoverer)((Object)this.score[i])).getNumberOfComponents();
        }
        this.motifIndexArray = new int[3];
        this.componentIndexArray = new int[this.score.length];
    }

    public IndependentProductScoringFunction(StringBuffer source) throws NonParsableException {
        super(source);
    }

    private void setStartsAndLengths(int[] length) throws IllegalArgumentException {
        int oldStart = 0;
        this.start = new int[this.score.length];
        this.partialLength = new int[this.score.length];
        this.isVariable = new boolean[this.score.length];
        for (int i = 0; i < this.score.length; ++i) {
            this.start[i] = oldStart;
            this.partialLength[i] = length[i];
            this.isVariable[i] = this.score[i] instanceof VariableLengthScoringFunction;
            if (!this.isVariable[i] && this.score[i].getLength() != this.partialLength[i]) {
                throw new IllegalArgumentException("Could not use length " + this.partialLength[i] + " for component " + i + ".");
            }
            oldStart += length[i];
        }
        this.partIList = new IntList();
    }

    private void setParamsStarts() {
        if (this.params == null) {
            this.params = new int[this.score.length + 1];
        }
        for (int i = 0; i < this.score.length; ++i) {
            int n = this.score[i].getNumberOfParameters();
            if (n == -1) {
                this.params = null;
                break;
            }
            this.params[i + 1] = this.params[i] + n;
        }
    }

    public IndependentProductScoringFunction clone() throws CloneNotSupportedException {
        IndependentProductScoringFunction clone = (IndependentProductScoringFunction)super.clone();
        clone.score = (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])this.score);
        clone.setStartsAndLengths(this.partialLength);
        clone.params = null;
        clone.setParamsStarts();
        clone.motifs = (int[])this.motifs.clone();
        clone.motifIndexArray = (int[])this.motifIndexArray.clone();
        clone.components = (int[])this.components.clone();
        clone.componentIndexArray = (int[])this.componentIndexArray.clone();
        return clone;
    }

    private int getSFIndex(int index) {
        int i;
        for (i = 1; i < this.params.length && index >= this.params[i]; ++i) {
        }
        return i - 1;
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        int i = this.getSFIndex(index);
        return this.score[i].getSizeOfEventSpaceForRandomVariablesOfParameter(index - this.params[i]);
    }

    public double getNormalizationConstant() {
        double norm = 1.0;
        for (int i = 0; i < this.score.length; ++i) {
            norm *= this.score[i].getNormalizationConstant();
        }
        return norm;
    }

    public double getPartialNormalizationConstant(int parameterIndex) throws Exception {
        int j = this.getSFIndex(parameterIndex);
        double partNorm = 1.0;
        for (int i = 0; i < this.score.length; ++i) {
            if (i == j) {
                partNorm *= this.score[i].getPartialNormalizationConstant(parameterIndex - this.params[i]);
                continue;
            }
            partNorm *= this.score[i].getNormalizationConstant();
        }
        return partNorm;
    }

    public double getEss() {
        return this.score[0].getEss();
    }

    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        Sample[] part = new Sample[data.length];
        for (int i = 0; i < this.score.length; ++i) {
            for (int j = 0; j < data.length; ++j) {
                part[j] = data[j].getInfixSample(this.start[i], this.partialLength[i]);
            }
            this.score[i].initializeFunction(index, freeParams, part, weights);
        }
        this.setParamsStarts();
    }

    protected void fromXML(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getInstanceName());
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(xml, "AlphabetContainer");
        this.length = XMLParser.extractIntForTag(xml, "length");
        this.score = (NormalizableScoringFunction[])ArrayHandler.cast(XMLParser.extractStorableArrayForTag(xml, "ScoringFunctions"));
        this.setStartsAndLengths(XMLParser.extractIntArrayForTag(xml, "partialLength"));
        this.setParamsStarts();
        this.prepare();
    }

    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    public double[] getCurrentParameterValues() throws Exception {
        int numPars = this.getNumberOfParameters();
        double[] pars = new double[numPars];
        int k = 0;
        for (int i = 0; i < this.score.length; ++i) {
            double[] help = this.score[i].getCurrentParameterValues();
            for (int j = 0; j < help.length; ++j) {
                pars[k++] = help[j];
            }
        }
        return pars;
    }

    public double getLogScore(Sequence seq, int start) {
        double s = 0.0;
        for (int i = 0; i < this.score.length; ++i) {
            if (this.isVariable[i]) {
                s += ((VariableLengthScoringFunction)this.score[i]).getLogScore(seq, start + this.start[i], this.partialLength[i]);
                continue;
            }
            s += this.score[i].getLogScore(seq, start + this.start[i]);
        }
        return s;
    }

    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double s = 0.0;
        for (int i = 0; i < this.score.length; ++i) {
            this.partIList.clear();
            s = this.isVariable[i] ? (s += ((VariableLengthScoringFunction)this.score[i]).getLogScoreAndPartialDerivation(seq, start + this.start[i], this.partialLength[i], this.partIList, partialDer)) : (s += this.score[i].getLogScoreAndPartialDerivation(seq, start + this.start[i], this.partIList, partialDer));
            for (int j = 0; j < this.partIList.length(); ++j) {
                indices.add(this.partIList.get(j) + this.params[i]);
            }
        }
        return s;
    }

    public int getNumberOfParameters() {
        if (this.params == null) {
            return -1;
        }
        return this.params[this.score.length];
    }

    public int getNumberOfRecommendedStarts() {
        int max = this.score[0].getNumberOfRecommendedStarts();
        for (int i = 1; i < this.score.length; ++i) {
            max = Math.max(max, this.score[i].getNumberOfRecommendedStarts());
        }
        return max;
    }

    public void setParameters(double[] params, int start) {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].setParameters(params, start + this.params[i]);
        }
    }

    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(10000);
        XMLParser.appendStorableWithTags(xml, this.alphabets, "AlphabetContainer");
        XMLParser.appendIntWithTags(xml, this.length, "length");
        XMLParser.appendStorableArrayWithTags(xml, this.score, "ScoringFunctions");
        XMLParser.appendIntArrayWithTags(xml, this.partialLength, "partialLength");
        XMLParser.addTags(xml, this.getInstanceName());
        return xml;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100000);
        for (int i = 0; i < this.score.length; ++i) {
            sb.append("sequence part beginning at " + this.start[i] + " with length " + this.partialLength[i] + "\n");
            sb.append(this.score[i].toString() + "\n");
        }
        return sb.toString();
    }

    public double getLogPriorTerm() {
        double val = 0.0;
        for (int i = 0; i < this.score.length; ++i) {
            val += this.score[i].getLogPriorTerm();
        }
        return val;
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].addGradientOfLogPriorTerm(grad, start + this.params[i]);
        }
    }

    public boolean isInitialized() {
        int i;
        for (i = 0; i < this.score.length && this.score[i].isInitialized(); ++i) {
        }
        return i == this.score.length;
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].initializeFunctionRandomly(freeParams);
        }
        this.setParamsStarts();
    }

    private void fillMotifIndexArray(int motifIndex) throws IndexOutOfBoundsException {
        this.motifIndexArray[0] = -1;
        for (int i = 1; i < this.motifs.length; ++i) {
            if (!(this.score[i - 1] instanceof MotifDiscoverer) || motifIndex < this.motifs[i - 1] || motifIndex >= this.motifs[i]) continue;
            this.motifIndexArray[0] = i - 1;
            this.motifIndexArray[1] = motifIndex - this.motifs[this.motifIndexArray[0]];
            this.motifIndexArray[2] = this.score[this.motifIndexArray[0]] instanceof MutableMotifDiscoverer ? 1 : -1;
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    public void initializeMotif(int motifIndex, Sample data, double[] weights) throws Exception {
        this.fillMotifIndexArray(motifIndex);
        if (this.motifIndexArray[2] >= 0) {
            ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).initializeMotif(this.motifIndexArray[1], data, weights);
            this.setParamsStarts();
        } else {
            System.out.println("warning: not possible");
        }
    }

    public boolean modifyMotif(int motifIndex, double[] weightsLeft, double[] weightsRight, double[][][][] replacementLeft, double[][][][] replacementRight, int offsetLeft, int offsetRight) throws Exception {
        this.fillMotifIndexArray(motifIndex);
        if (this.motifIndexArray[2] >= 0) {
            boolean b = ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).modifyMotif(this.motifIndexArray[1], weightsLeft, weightsRight, replacementLeft, replacementRight, offsetLeft, offsetRight);
            this.setParamsStarts();
            return b;
        }
        return false;
    }

    public boolean modifyMotif(int motifIndex, int offsetLeft, int offsetRight) throws Exception {
        this.fillMotifIndexArray(motifIndex);
        if (this.motifIndexArray[2] >= 0) {
            boolean b = ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).modifyMotif(this.motifIndexArray[1], offsetLeft, offsetRight);
            this.setParamsStarts();
            return b;
        }
        return false;
    }

    public int[] determineNotSignificantPositionsFor(int motif, Sample[] data, double[][] weights, int classIdx) {
        this.fillMotifIndexArray(motif);
        if (this.motifIndexArray[2] >= 0) {
            Sample[] part = new Sample[data.length];
            for (int j = 0; j < part.length; ++j) {
                part[j] = data[j].getInfixSample(this.start[this.motifIndexArray[0]], this.partialLength[this.motifIndexArray[0]]);
            }
            return ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).determineNotSignificantPositionsFor(this.motifIndexArray[1], part, weights, classIdx);
        }
        return new int[]{0, 0};
    }

    private void fillComponentIndexArray(int componentIndex) {
        for (int i = this.score.length - 1; i >= 0; --i) {
            this.componentIndexArray[i] = componentIndex / this.components[i];
            componentIndex %= this.components[i];
        }
    }

    private void fillMotifIndexArrayForComponent(int componentIndex, int motifIndex) throws IndexOutOfBoundsException {
        this.fillComponentIndexArray(componentIndex);
        for (int i = 0; i < this.score.length; ++i) {
            if (!(this.score[i] instanceof MotifDiscoverer)) continue;
            int n = ((MotifDiscoverer)((Object)this.score[i])).getNumberOfMotifsInComponent(this.componentIndexArray[i]);
            if (motifIndex < n) {
                this.motifIndexArray[0] = i;
                this.motifIndexArray[1] = motifIndex;
                this.motifIndexArray[2] = this.score[this.motifIndexArray[0]] instanceof MutableMotifDiscoverer ? 1 : -1;
                this.motifIndexArray[2] = this.motifIndexArray[2];
                continue;
            }
            motifIndex -= n;
        }
        throw new IndexOutOfBoundsException();
    }

    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        this.fillMotifIndexArrayForComponent(component, motif);
        return this.motifs[this.motifIndexArray[0]] + ((MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).getGlobalIndexOfMotifInComponent(this.componentIndexArray[this.motifIndexArray[0]], this.motifIndexArray[1]);
    }

    public int getIndexOfMaximalComponentFor(Sequence sequence) throws Exception {
        int c = 0;
        int old = 1;
        for (int i = 0; i < this.score.length; ++i) {
            int idx = this.score[i] instanceof AbstractMixtureScoringFunction ? ((AbstractMixtureScoringFunction)this.score[i]).getIndexOfMaximalComponentFor(sequence, this.start[i]) : (this.score[i] instanceof MotifDiscoverer ? ((MotifDiscoverer)((Object)this.score[i])).getIndexOfMaximalComponentFor(sequence.getSubSequence(this.score[i].getAlphabetContainer(), this.start[i], this.partialLength[i])) : 0);
            c += old * idx;
            old = this.components[i];
        }
        return c;
    }

    public int getMotifLength(int motif) {
        this.fillMotifIndexArray(motif);
        return ((MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).getMotifLength(this.motifIndexArray[1]);
    }

    public int getNumberOfComponents() {
        return this.components[this.score.length - 1];
    }

    public int getNumberOfMotifs() {
        return this.motifs[this.score.length];
    }

    public int getNumberOfMotifsInComponent(int component) {
        this.fillComponentIndexArray(component);
        int anz = 0;
        for (int i = 0; i < this.score.length; ++i) {
            if (!(this.score[i] instanceof MotifDiscoverer)) continue;
            anz += ((MotifDiscoverer)((Object)this.score[i])).getNumberOfMotifsInComponent(this.componentIndexArray[i]);
        }
        return anz;
    }

    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile dist) throws Exception {
        this.fillMotifIndexArrayForComponent(component, motif);
        int w = ((MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).getMotifLength(this.motifIndexArray[1]);
        double[] erg = new double[this.length - w + 1];
        Arrays.fill(erg, Double.NEGATIVE_INFINITY);
        double[] part = ((MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).getProfileOfScoresFor(this.componentIndexArray[this.motifIndexArray[0]], this.motifIndexArray[1], sequence, this.start[this.motifIndexArray[0]] + startpos, dist);
        System.arraycopy(part, 0, erg, this.start[this.motifIndexArray[0]], this.partialLength[this.motifIndexArray[0]] - w + 1);
        return erg;
    }

    public StrandedLocatedSequenceAnnotationWithLength.Strand getStrandFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        this.fillMotifIndexArrayForComponent(component, motif);
        return ((MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).getStrandFor(this.componentIndexArray[this.motifIndexArray[0]], this.motifIndexArray[1], sequence, startpos);
    }
}

