/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters.validation;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.classifier.AbstractClassifier;
import de.jstacs.io.XMLParser;
import de.jstacs.models.AbstractModel;
import de.jstacs.models.Model;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.validation.ParameterValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorableValidator
implements ParameterValidator {
    private String errorMessage;
    private Class clazz;
    private boolean trained;

    public StorableValidator(Class<? extends Storable> clazz, boolean trained) throws Exception {
        if (!AbstractModel.class.isAssignableFrom(clazz) && !AbstractClassifier.class.isAssignableFrom(clazz)) {
            throw new Exception("Class is not a subtype of StorableAbstractClassifier or StorableAbstractModel");
        }
        this.clazz = clazz;
        this.trained = trained;
    }

    public StorableValidator(Class<? extends Storable> clazz) throws Exception {
        if (!Storable.class.isAssignableFrom(clazz)) {
            throw new Exception("Class is not a subtype of Storable");
        }
        this.clazz = clazz;
        this.trained = false;
    }

    public StorableValidator(StringBuffer buf) throws NonParsableException {
        this.fromXML(buf);
    }

    @Override
    public StorableValidator clone() throws CloneNotSupportedException {
        try {
            StorableValidator clone = null;
            clone = AbstractModel.class.isAssignableFrom(this.clazz) || AbstractClassifier.class.isAssignableFrom(this.clazz) ? new StorableValidator(this.clazz, this.trained) : new StorableValidator(this.clazz);
            clone.errorMessage = this.errorMessage;
            return clone;
        }
        catch (Exception e) {
            throw new CloneNotSupportedException(e.getCause().getMessage());
        }
    }

    @Override
    public boolean checkValue(Object value) {
        if (AbstractModel.class.isAssignableFrom(this.clazz) && value instanceof AbstractModel) {
            if (!this.trained || ((Model)value).isTrained()) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = "The model must be trained.";
            return false;
        }
        if (AbstractClassifier.class.isAssignableFrom(this.clazz) && value instanceof AbstractClassifier) {
            if (!this.trained || ((AbstractClassifier)value).isTrained()) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = "The classifier must be trained.";
            return false;
        }
        StringBuffer buf = null;
        if (value instanceof FileParameter.FileRepresentation) {
            String content = ((FileParameter.FileRepresentation)value).getContent();
            buf = new StringBuffer(content);
        } else if (value instanceof String) {
            buf = new StringBuffer((String)value);
        } else if (value instanceof StringBuffer) {
            buf = (StringBuffer)value;
        }
        try {
            buf = XMLParser.extractForTag(buf, "object");
            String className = XMLParser.extractStringForTag(buf, "className");
            Class<?> c = Class.forName(className);
            if (this.clazz.isAssignableFrom(c)) {
                boolean modelTrained = false;
                if (AbstractModel.class.isAssignableFrom(c)) {
                    Model model = (Model)c.getConstructor(StringBuffer.class).newInstance(buf);
                    modelTrained = model.isTrained();
                } else if (AbstractClassifier.class.isAssignableFrom(c)) {
                    AbstractClassifier classifier = (AbstractClassifier)c.getConstructor(StringBuffer.class).newInstance(buf);
                    modelTrained = classifier.isTrained();
                } else {
                    c.getConstructor(StringBuffer.class).newInstance(buf);
                }
                if (!this.trained || modelTrained) {
                    this.errorMessage = null;
                    return true;
                }
                this.errorMessage = "The classifier must be trained.";
                return false;
            }
            this.errorMessage = "File content was not of the correct class " + this.clazz.getName() + " but of " + className;
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorMessage = "The file could not be parsed: " + e.getCause();
            return false;
        }
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendStringWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendBooleanWithTags(buf, this.trained, "trained");
        XMLParser.appendStringWithTags(buf, this.clazz.getName(), "class");
        XMLParser.addTags(buf, "TrainedValidator");
        return buf;
    }

    public void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "TrainedValidator");
        this.errorMessage = XMLParser.extractStringForTag(representation, "errorMessage");
        this.trained = XMLParser.extractBooleanForTag(representation, "trained");
        try {
            this.clazz = Class.forName(XMLParser.extractStringForTag(representation, "class"));
        }
        catch (Exception e) {
            throw new NonParsableException(e.getMessage());
        }
    }
}

