/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters.validation;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.ReferenceConstraint;

public class SimpleReferenceConstraint
extends ReferenceConstraint {
    private int comparisonOperator;

    public SimpleReferenceConstraint(SimpleParameter constraintParameter, int comparisonOperator) {
        super(constraintParameter);
        this.comparisonOperator = comparisonOperator;
    }

    public SimpleReferenceConstraint(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public SimpleReferenceConstraint clone() throws CloneNotSupportedException {
        SimpleReferenceConstraint clone = new SimpleReferenceConstraint(null, this.comparisonOperator);
        this.fillWithStandardFieldForClone(clone);
        return clone;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean check(Object value) {
        if (value == null) {
            this.errorMessage = "Value was null";
            return false;
        }
        if (!this.constraintParameter.hasDefaultOrIsSet()) {
            this.errorMessage = "Value of parameter " + this.constraintParameter.getName() + " must be set first";
            return false;
        }
        Object constValue = this.constraintParameter.getValue();
        if (this.comparisonOperator == 1) {
            if (!this.constraintParameter.getValue().equals(value)) {
                this.errorMessage = "Value must be equal to value of " + this.constraintParameter.getName();
                return false;
            }
        } else {
            if (this.comparisonOperator != 2 && this.comparisonOperator != 3 && this.comparisonOperator != 4 && this.comparisonOperator != 5) {
                this.errorMessage = "Wrong comparison operator";
                return false;
            }
            if (value instanceof Comparable && constValue instanceof Comparable) {
                if (this.comparisonOperator == 2 && ((Comparable)value).compareTo(constValue) >= 0) {
                    this.errorMessage = "Value must be less than value of " + this.constraintParameter.getName();
                    return false;
                }
                if (this.comparisonOperator == 3 && ((Comparable)value).compareTo(constValue) <= 0) {
                    this.errorMessage = "Value must be greater than value of " + this.constraintParameter.getName();
                    return false;
                }
                if (this.comparisonOperator == 4 && ((Comparable)value).compareTo(constValue) > 0) {
                    this.errorMessage = "Value must be less than or equal to value of " + this.constraintParameter.getName();
                    return false;
                }
                if (this.comparisonOperator == 5 && ((Comparable)value).compareTo(constValue) < 0) {
                    this.errorMessage = "Value must be greater than or equal to value of " + this.constraintParameter.getName();
                    return false;
                }
            } else {
                this.errorMessage = "Both values must be comparable";
                return false;
            }
        }
        this.errorMessage = null;
        return true;
    }

    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "superConstraint");
        XMLParser.appendIntWithTags(buf, this.comparisonOperator, "comparisonOperator");
        XMLParser.addTags(buf, "simpleReferenceConstraint");
        return buf;
    }

    public void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "simpleReferenceConstraint");
        super.fromXML(XMLParser.extractForTag(representation, "superConstraint"));
        this.comparisonOperator = XMLParser.extractIntForTag(representation, "comparisonOperator");
    }
}

