/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.CollectionParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.RangeIterator;
import de.jstacs.parameters.Rangeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterSet
implements Storable,
Cloneable,
RangeIterator {
    protected ParameterList parameters;
    protected String errorMessage;
    protected boolean ranged = false;
    protected ParameterSetContainer parent;
    private long id;

    public ParameterSet() throws UnsupportedOperationException {
        this.id = System.currentTimeMillis() + (long)this.hashCode();
    }

    public ParameterSet clone() throws CloneNotSupportedException {
        ParameterSet ret = (ParameterSet)super.clone();
        if (this.parameters != null) {
            ret.initParameterList(this.parameters.size());
            for (int i = 0; i < this.parameters.size(); ++i) {
                ret.parameters.add(i, ((Parameter)this.parameters.get(i)).clone());
            }
            for (Parameter par : ret.parameters) {
                ParameterSet set;
                if (par.getNeededReferenceId() == null || (set = this.findParameterSet(par.getNeededReferenceId(), false)) == null) continue;
                par.setNeededReference(set);
            }
        }
        this.propagateId(this.id, this, false);
        return ret;
    }

    protected final void initParameterList() {
        this.parameters = new ParameterList();
    }

    protected final void initParameterList(int initCapacity) {
        this.parameters = new ParameterList(initCapacity);
    }

    protected abstract void loadParameters() throws Exception;

    public boolean parametersLoaded() {
        return this.parameters != null;
    }

    public boolean isAtomic() {
        if (this.parameters == null) {
            try {
                this.loadParameters();
                if (this.ranged) {
                    this.replaceParametersWithRangedInstance();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (((Parameter)this.parameters.get(i)).isAtomic()) continue;
            return false;
        }
        return true;
    }

    public boolean hasDefaultOrIsSet() {
        if (this.parameters == null) {
            try {
                this.loadParameters();
                if (this.ranged) {
                    this.replaceParametersWithRangedInstance();
                }
            }
            catch (Exception e) {
                this.errorMessage = "Parameters could not be loaded";
                e.printStackTrace();
                return false;
            }
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (!((Parameter)this.parameters.get(i)).isRequired() || ((Parameter)this.parameters.get(i)).hasDefaultOrIsSet()) continue;
            return false;
        }
        this.errorMessage = null;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    protected ParameterSet(Parameter[] parameters) {
        this.id = System.currentTimeMillis() + (long)this.hashCode();
        this.initParameterList(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            this.parameters.add(parameters[i]);
        }
    }

    protected ParameterSet(ArrayList<Parameter> parameters) {
        this.id = System.currentTimeMillis() + (long)this.hashCode();
        this.initParameterList();
        Iterator<Parameter> parIt = parameters.iterator();
        while (parIt.hasNext()) {
            this.parameters.add(parIt.next());
        }
    }

    public ParameterSet(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public int getNumberOfParameters() {
        if (this.parameters == null) {
            try {
                this.loadParameters();
                if (this.ranged) {
                    this.replaceParametersWithRangedInstance();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
        if (this.parameters != null) {
            return this.parameters.size();
        }
        return 0;
    }

    public Parameter getParameterAt(int i) {
        if (this.parameters == null) {
            try {
                this.loadParameters();
                if (this.ranged) {
                    this.replaceParametersWithRangedInstance();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return (Parameter)this.parameters.get(i);
    }

    public void makeRanged() throws Exception {
        if (this.parameters != null) {
            this.replaceParametersWithRangedInstance();
        }
        this.ranged = true;
    }

    @Override
    public boolean next() throws ParameterException {
        if (this.ranged) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!(this.parameters.get(i) instanceof RangeIterator)) continue;
                RangeIterator ri = (RangeIterator)this.parameters.get(i);
                if (ri.next()) {
                    return true;
                }
                ri.resetToFirst();
            }
        }
        return false;
    }

    @Override
    public void resetToFirst() {
        if (this.ranged) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!(this.parameters.get(i) instanceof RangeIterator)) continue;
                ((RangeIterator)this.parameters.get(i)).resetToFirst();
            }
        }
    }

    @Override
    public int getNumberOfValues() {
        if (this.ranged) {
            int erg = 1;
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (!(this.parameters.get(i) instanceof RangeIterator)) continue;
                erg *= ((RangeIterator)this.parameters.get(i)).getNumberOfValues();
            }
            return erg;
        }
        return 1;
    }

    @Override
    public boolean isRanged() {
        if (this.ranged) {
            return this.getNumberOfValues() > 1;
        }
        return false;
    }

    @Override
    public String valuesToString() {
        String erg = null;
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.ranged && this.parameters.get(i) instanceof RangeIterator) {
                if (erg == null) {
                    erg = ((RangeIterator)this.parameters.get(i)).valuesToString();
                    continue;
                }
                erg = erg + " x " + ((RangeIterator)this.parameters.get(i)).valuesToString();
                continue;
            }
            erg = erg == null ? "[" + ((Parameter)this.parameters.get(i)).getValue().toString() + "]" : erg + " x [" + ((Parameter)this.parameters.get(i)).getValue().toString() + "]";
        }
        return erg;
    }

    protected void replaceParametersWithRangedInstance() throws Exception {
        for (int i = 0; i < this.parameters.size(); ++i) {
            Rangeable r;
            if (!(this.parameters.get(i) instanceof Rangeable) || !(r = (Rangeable)this.parameters.get(i)).isRangeable()) continue;
            this.parameters.set(i, r.getRangedInstance());
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        if (this.parameters != null) {
            StringBuffer buf2 = new StringBuffer();
            XMLParser.appendIntWithTags(buf2, this.parameters.size(), "numberOfParameters");
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (this.parameters.get(i) == null) {
                    XMLParser.appendStringWithTags(buf2, "null", "parameter");
                    continue;
                }
                StringBuffer buf3 = new StringBuffer();
                XMLParser.appendStringWithTags(buf3, ((Parameter)this.parameters.get(i)).getClass().getName(), "className");
                buf3.append(((Parameter)this.parameters.get(i)).toXML());
                XMLParser.addTags(buf3, "parameter");
                buf2.append(buf3);
            }
            XMLParser.addTags(buf2, "set");
            buf.append(buf2);
        } else {
            XMLParser.appendStringWithTags(buf, "null", "set");
        }
        XMLParser.appendBooleanWithTags(buf, this.ranged, "ranged");
        XMLParser.appendLongWithTags(buf, this.id, "id");
        XMLParser.addTags(buf, "parameterSet");
        return buf;
    }

    public void simplify() {
        if (this.parameters == null) {
            return;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) instanceof CollectionParameter) {
                ((Parameter)this.parameters.get(i)).simplify();
                continue;
            }
            if (!(((Parameter)this.parameters.get(i)).getValue() instanceof ParameterSet)) continue;
            ((ParameterSet)((Parameter)this.parameters.get(i)).getValue()).simplify();
        }
    }

    public void reset() {
        this.parameters = null;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer help;
        StringBuffer buf = XMLParser.extractForTag(representation = XMLParser.extractForTag(representation, "parameterSet"), "set");
        if (!buf.toString().equals("null")) {
            int numPars = XMLParser.extractIntForTag(buf, "numberOfParameters");
            this.parameters = new ParameterList(numPars);
            for (int i = 0; i < numPars; ++i) {
                String par = XMLParser.extractStringForTag(buf, "parameter");
                if (par.equals("null")) {
                    this.parameters.add(null);
                    continue;
                }
                StringBuffer buf2 = new StringBuffer(par);
                String className = XMLParser.extractStringForTag(buf2, "className");
                try {
                    this.parameters.add((Parameter)Class.forName(className).getConstructor(StringBuffer.class).newInstance(buf2));
                    continue;
                }
                catch (Exception e) {
                    System.out.println("parameter: " + i);
                    System.out.println("class    : " + className);
                    System.out.println("buffer   : " + par);
                    NonParsableException n = new NonParsableException(e.getMessage());
                    n.setStackTrace(e.getStackTrace());
                    System.out.print("ParameterSet: ");
                    e.printStackTrace();
                    throw n;
                }
            }
        }
        this.ranged = (help = XMLParser.extractForTag(representation, "ranged")) == null ? false : Boolean.parseBoolean(help.toString());
        this.id = XMLParser.extractLongForTag(representation, "id");
        this.propagateId(this.id, this, false);
        this.recieveId();
    }

    protected void recieveId() {
        if (this.parameters != null) {
            for (Parameter par : this.parameters) {
                Long neededId = par.getNeededReferenceId();
                if (neededId == null) continue;
                par.setNeededReference(this.findParameterSet(neededId, false));
            }
        }
    }

    private ParameterSet findParameterSet(long id, boolean fwd) {
        if (id == this.id) {
            return this;
        }
        if (!fwd && this.getParent() != null && this.getParent().getParent() != null) {
            ParameterSet set = this.getParent().getParent().findParameterSet(id, false);
            if (set != null) {
                return set;
            }
            return null;
        }
        if (this.parameters != null) {
            for (Parameter par : this.parameters) {
                ParameterSet set;
                if (!(par instanceof ParameterSetContainer) || (set = ((ParameterSetContainer)par).getValue().findParameterSet(id, true)) == null) continue;
                return set;
            }
        }
        return null;
    }

    protected void propagateId() {
        this.propagateId(this.id, this, false);
    }

    private boolean propagateId(long id, ParameterSet set, boolean fwd) {
        if (!fwd && this.getParent() != null && this.getParent().getParent() != null) {
            return this.getParent().getParent().propagateId(id, set, false);
        }
        if (this.parameters != null) {
            for (Parameter par : this.parameters) {
                boolean re;
                if (par.getNeededReferenceId() != null && par.getNeededReferenceId() == id) {
                    par.setNeededReference(set);
                    return true;
                }
                if (!(par instanceof ParameterSetContainer) || !(re = ((ParameterSetContainer)par).getValue().propagateId(id, set, true))) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public long getId() {
        return this.id;
    }

    public ParameterSetContainer getParent() {
        return this.parent;
    }

    public void setParent(ParameterSetContainer parent) {
        this.parent = parent;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ParameterList
    extends ArrayList<Parameter> {
        private static final long serialVersionUID = 5646161850340681495L;

        public ParameterList() {
        }

        public ParameterList(Collection<? extends Parameter> c) {
            super(c);
            Iterator<? extends Parameter> it = c.iterator();
            while (it.hasNext()) {
                it.next().setParent(ParameterSet.this);
            }
        }

        public ParameterList(int initialCapacity) {
            super(initialCapacity);
        }

        @Override
        public void add(int index, Parameter element) {
            element.setParent(ParameterSet.this);
            super.add(index, element);
        }

        @Override
        public boolean add(Parameter o) {
            o.setParent(ParameterSet.this);
            return super.add(o);
        }

        @Override
        public boolean addAll(Collection<? extends Parameter> c) {
            Iterator<? extends Parameter> it = c.iterator();
            while (it.hasNext()) {
                it.next().setParent(ParameterSet.this);
            }
            return super.addAll(c);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Parameter> c) {
            Iterator<? extends Parameter> it = c.iterator();
            while (it.hasNext()) {
                it.next().setParent(ParameterSet.this);
            }
            return super.addAll(index, c);
        }
    }
}

