/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery;

import de.jstacs.classifier.utils.PValueComputation;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.PermutedSequence;
import de.jstacs.data.sequences.annotation.MotifAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.results.NumericalResult;
import de.jstacs.scoringFunctions.homogeneous.HMMScoringFunction;
import de.jstacs.utils.DoubleList;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignificantMotifOccurrencesFinder {
    private RandomSeqType type;
    private Sample bg;
    private MotifDiscoverer disc;
    private int numSequences;
    private double sign;

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, RandomSeqType type, int numSequences, double sign) {
        this.disc = disc;
        if (type == RandomSeqType.BACKGROUND) {
            throw new IllegalArgumentException("This type can not be used in this constructor.");
        }
        this.type = type;
        this.numSequences = numSequences;
        this.sign = sign;
    }

    public SignificantMotifOccurrencesFinder(MotifDiscoverer disc, Sample bg, double sign) {
        this.disc = disc;
        this.type = RandomSeqType.BACKGROUND;
        this.numSequences = bg.getNumberOfElements();
        this.bg = bg;
        this.sign = sign;
    }

    private void createBgSample(Sequence seq) {
        int order = this.type.getOrder();
        if (order >= 0) {
            HMMScoringFunction hmm = new HMMScoringFunction(seq.getAlphabetContainer(), order, 0.0, new double[order + 1], true, true, 1);
            try {
                hmm.initializeFunction(0, false, new Sample[]{new Sample("", seq)}, new double[][]{{1.0}});
                if (order > 0) {
                    double[][][] condProbs = hmm.getAllConditionalStationaryDistributions();
                    DoubleList list = new DoubleList((int)(1.5 * Math.pow(seq.getAlphabetContainer().getAlphabetLengthAt(0), condProbs.length)));
                    for (int i = 0; i < condProbs.length; ++i) {
                        for (int j = 0; j < condProbs[i].length; ++j) {
                            for (int k = 0; k < condProbs[i][j].length; ++k) {
                                list.add(Math.log(condProbs[i][j][k]));
                            }
                        }
                    }
                    hmm.setParameters(list.toArray(), 0);
                }
                this.bg = hmm.emit(this.numSequences, seq.getLength());
            }
            catch (Exception doesnothappen) {
                doesnothappen.printStackTrace();
            }
        }
    }

    public MotifAnnotation[] findSignificantMotifOccurrences(int motif, Sequence seq, int start) throws Exception {
        int[][] idxs = this.computeIndices(motif);
        LinkedList<MotifAnnotation> list = new LinkedList<MotifAnnotation>();
        this.findSignificantMotifOccurrences(motif, seq, start, idxs[0], idxs[1], list, Integer.MAX_VALUE);
        return list.toArray(new MotifAnnotation[0]);
    }

    private int[][] computeIndices(int motif) {
        int num = 0;
        for (int i = 0; i < this.disc.getNumberOfComponents(); ++i) {
            int loc = this.getLocalIndexOfMotifInComponent(i, motif);
            if (loc <= -1) continue;
            ++num;
        }
        int[][] idxs = new int[2][num];
        num = 0;
        for (int i = 0; i < this.disc.getNumberOfComponents(); ++i) {
            int loc = this.getLocalIndexOfMotifInComponent(i, motif);
            if (loc <= -1) continue;
            idxs[0][num] = i;
            idxs[1][num] = loc;
            ++num;
        }
        return idxs;
    }

    private void findSignificantMotifOccurrences(int motif, Sequence seq, int start, int[] idxsOfUsedComponents, int[] idxsOfMotifsInComponents, AbstractList<MotifAnnotation> list, int addMax) throws Exception {
        int i;
        int num = 0;
        this.createBgSample(seq);
        Sequence permSeq = null;
        LinkedList<double[][]> scoreList = new LinkedList<double[][]>();
        Object temp = null;
        for (i = 0; i < this.numSequences; ++i) {
            permSeq = this.type == RandomSeqType.PERMUTED ? new PermutedSequence(seq) : this.bg.getElementAt(i);
            temp = new double[idxsOfUsedComponents.length][];
            for (int j = 0; j < idxsOfUsedComponents.length; ++j) {
                temp[j] = this.disc.getProfileOfScoresFor(idxsOfUsedComponents[j], idxsOfMotifsInComponents[j], permSeq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                num += temp[j].length;
            }
            scoreList.add((double[][])temp);
        }
        double[] scores = new double[num];
        Iterator it = scoreList.iterator();
        num = 0;
        while (it.hasNext()) {
            temp = (double[][])it.next();
            for (i = 0; i < ((double[][])temp).length; ++i) {
                System.arraycopy(temp[i], 0, scores, num, temp[i].length);
                num += temp[i].length;
            }
        }
        Arrays.sort(scores);
        temp = new double[idxsOfUsedComponents.length][];
        for (i = 0; i < idxsOfUsedComponents.length; ++i) {
            temp[i] = this.disc.getProfileOfScoresFor(idxsOfUsedComponents[i], idxsOfMotifsInComponents[i], seq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
        }
        int signIndex = PValueComputation.getBorder(scores, this.sign);
        double thresh = PValueComputation.getThreshold(scores, signIndex);
        int length = this.disc.getMotifLength(motif);
        int listIndex = list.size();
        DoubleList pValues = new DoubleList();
        for (i = 0; i < ((double[][])temp).length; ++i) {
            for (int j = 0; j < temp[i].length; ++j) {
                if (!(temp[i][j] > thresh)) continue;
                double pVal = PValueComputation.getPValue(scores, temp[i][j], signIndex);
                pValues.add(pVal);
                list.add(new MotifAnnotation("motif* " + motif, j + start, length, this.disc.getStrandFor(idxsOfUsedComponents[i], idxsOfMotifsInComponents[i], seq, j + start), new NumericalResult("component", "the component of the model where this motif was found", idxsOfUsedComponents[i]), new NumericalResult("p-value", "", pVal)));
            }
        }
        if (pValues.length() > addMax) {
            double[] array = pValues.toArray();
            Arrays.sort(array);
            for (i = 0; i < pValues.length(); ++i) {
                if (pValues.get(i) >= array[addMax]) {
                    list.remove(listIndex);
                    continue;
                }
                ++listIndex;
            }
        }
    }

    public Sample annotateMotifs(int startPos, Sample data) throws Exception {
        return this.annotateMotifs(startPos, data, Integer.MAX_VALUE);
    }

    public Sample annotateMotifs(Sample data) throws Exception {
        return this.annotateMotifs(0, data, Integer.MAX_VALUE);
    }

    public Sample annotateMotifs(Sample data, int addMax) throws Exception {
        return this.annotateMotifs(0, data, addMax);
    }

    public Sample annotateMotifs(int startPos, Sample data, int addMax) throws Exception {
        int j;
        int n = data.getNumberOfElements();
        int m = this.disc.getNumberOfMotifs();
        int[][][] idxs = new int[m][][];
        Sequence[] seqs = new Sequence[n];
        for (j = 0; j < m; ++j) {
            idxs[j] = this.computeIndices(j);
        }
        LinkedList<MotifAnnotation> seqAn = new LinkedList<MotifAnnotation>();
        SequenceAnnotation[] empty = new SequenceAnnotation[]{};
        for (int i = 0; i < n; ++i) {
            seqs[i] = data.getElementAt(i);
            seqAn.clear();
            for (j = 0; j < m; ++j) {
                this.findSignificantMotifOccurrences(j, seqs[i], startPos, idxs[j][0], idxs[j][1], seqAn, addMax);
            }
            seqs[i] = seqs[i].annotate(false, seqAn.toArray(empty));
        }
        return new Sample("annotated", seqs);
    }

    private int getLocalIndexOfMotifInComponent(int component, int motif) {
        for (int i = 0; i < this.disc.getNumberOfMotifsInComponent(component); ++i) {
            if (this.disc.getGlobalIndexOfMotifInComponent(component, i) != motif) continue;
            return i;
        }
        return -1;
    }

    public double[][] getPValuesForEachNucleotide(Sample data, int component, int motif, boolean addOnlyBest) throws Exception {
        double[][] res = new double[data.getNumberOfElements()][];
        for (int i = 0; i < res.length; ++i) {
            res[i] = this.getPValueForNucleotides(data.getElementAt(i), 0, component, motif, addOnlyBest);
        }
        return res;
    }

    private double[] getPValueForNucleotides(Sequence seq, int start, int component, int motif, boolean addOnlyBest) throws Exception {
        int i;
        this.createBgSample(seq);
        Sequence bgSeq = null;
        LinkedList<double[]> scoreList = new LinkedList<double[]>();
        double[] temp = null;
        int num = 0;
        for (i = 0; i < this.numSequences; ++i) {
            bgSeq = this.type == RandomSeqType.PERMUTED ? new PermutedSequence(seq) : this.bg.getElementAt(i);
            temp = this.disc.getProfileOfScoresFor(component, motif, bgSeq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
            num += temp.length;
            scoreList.add(temp);
        }
        double[] scores = new double[num];
        Iterator it = scoreList.iterator();
        num = 0;
        while (it.hasNext()) {
            temp = (double[])it.next();
            System.arraycopy(temp, 0, scores, num, temp.length);
            num += temp.length;
        }
        Arrays.sort(scores);
        temp = this.disc.getProfileOfScoresFor(component, motif, seq, start, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
        double[] res = new double[seq.getLength() - start];
        Arrays.fill(res, 1.0);
        int length = this.disc.getMotifLength(motif);
        if (addOnlyBest) {
            int idx = SignificantMotifOccurrencesFinder.getIndexOfMax(temp);
            double p = PValueComputation.getPValue(scores, temp[idx]);
            for (i = 0; i < length; ++i) {
                res[idx + i] = p;
            }
        } else {
            for (i = 0; i < temp.length; ++i) {
                res[i] = PValueComputation.getPValue(scores, temp[i]);
            }
            for (i = res.length - 1; i >= 0; --i) {
                int k = i - 1;
                for (int j = 1; j < length && k >= 0; ++j, --k) {
                    if (!(res[i] > res[k])) continue;
                    res[i] = res[k];
                }
            }
        }
        return res;
    }

    private static int getIndexOfMax(double ... values) {
        int idx = 0;
        for (int i = 1; i < values.length; ++i) {
            if (!(values[i] > values[idx])) continue;
            idx = i;
        }
        return idx;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RandomSeqType {
        BACKGROUND(-2),
        PERMUTED(-1),
        hMM0(0),
        hMM1(1),
        hMM2(2),
        hMM3(3),
        hMM4(4),
        hMM5(5);

        private final int order;

        private RandomSeqType(int order) {
            this.order = order;
        }

        public int getOrder() {
            return this.order;
        }
    }
}

