/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.RecursiveSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import java.util.Random;

public class PermutedSequence
extends RecursiveSequence {
    private static Random r = new Random();
    private int[] permutation;

    public PermutedSequence(Sequence seq) throws WrongAlphabetException {
        super(seq.getAlphabetContainer(), seq);
        if (!seq.getAlphabetContainer().isSimple()) {
            throw new WrongAlphabetException("Alphabet must be simple");
        }
        this.permutation = new int[seq.getLength()];
        for (int i = 0; i < this.permutation.length; ++i) {
            this.permutation[i] = i;
        }
        for (int i = this.permutation.length - 1; i >= 0; --i) {
            int temp = r.nextInt(i + 1);
            int temp2 = this.permutation[i];
            this.permutation[i] = this.permutation[temp];
            this.permutation[temp] = temp2;
        }
    }

    private PermutedSequence(Sequence seq, SequenceAnnotation[] annotation, int[] perm) {
        super(seq.getAlphabetContainer(), annotation, seq);
        this.permutation = perm;
    }

    protected int getIndex(int pos) {
        return this.permutation[pos];
    }

    public int getLength() {
        return this.permutation.length;
    }

    protected Sequence flatCloneWithoutAnnotation() {
        try {
            return new PermutedSequence(this.content, null, this.permutation);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }
}

