/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.assessment;

import de.jstacs.WrongAlphabetException;
import de.jstacs.classifier.AbstractClassifier;
import de.jstacs.classifier.ClassDimensionException;
import de.jstacs.classifier.MeasureParameters;
import de.jstacs.classifier.assessment.ClassifierAssessment;
import de.jstacs.classifier.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.classifier.assessment.RepeatedSubSamplingAssessParameterSet;
import de.jstacs.data.Sample;
import de.jstacs.models.Model;
import de.jstacs.utils.ProgressUpdater;

public class RepeatedSubSamplingExperiment
extends ClassifierAssessment {
    protected RepeatedSubSamplingExperiment(AbstractClassifier[] aCs, Model[][] aMs, boolean buildClassifiersByCrossProduct, boolean checkAlphabetConsistencyAndLength) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, aMs, buildClassifiersByCrossProduct, checkAlphabetConsistencyAndLength);
    }

    public RepeatedSubSamplingExperiment(AbstractClassifier ... aCs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs);
    }

    public RepeatedSubSamplingExperiment(boolean buildClassifiersByCrossProduct, Model[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(buildClassifiersByCrossProduct, aMs);
    }

    public RepeatedSubSamplingExperiment(AbstractClassifier[] aCs, boolean buildClassifiersByCrossProduct, Model[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, buildClassifiersByCrossProduct, aMs);
    }

    protected void evaluateClassifier(MeasureParameters mp, ClassifierAssessmentAssessParameterSet assessPS, Sample[] s, ProgressUpdater pU) throws IllegalArgumentException, Exception {
        RepeatedSubSamplingAssessParameterSet tempAssessPS = null;
        try {
            tempAssessPS = (RepeatedSubSamplingAssessParameterSet)assessPS;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Given AssessParameterSet assessPS is not of type RepeatedSubSamlplingAssessParameterSet.");
        }
        int eL = tempAssessPS.getElementLength();
        boolean exceptionIfMPNotComputable = tempAssessPS.getExceptionIfMPNotComputable();
        int repeats = tempAssessPS.getRepeats();
        int[] trainN = tempAssessPS.getTrain_TestNumbers(true);
        int[] testN = tempAssessPS.getTrain_TestNumbers(false);
        int subSeqL = tempAssessPS.getElementLength();
        if (trainN.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedSubSamlpingAssessParameterSet contains a invalid parameter trainDataNumbers. trainDataNumbers (int[], number of train-data items that should be subsampled for each class) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        if (testN.length != this.myAbstractClassifier[0].getNumberOfClasses()) {
            throw new IllegalArgumentException("Given RepeatedSubSamlpingAssessParameterSet contains a invalid parameter testDataNumbers. testDataNumbers (int[], number of test-data items that should be subsampled for each class) must contain as much entries as classes the local classifers are able to distinguish.");
        }
        Sample[] tempS = new Sample[s.length];
        for (int i = 0; i < tempS.length; ++i) {
            tempS[i] = s[i].getElementLength() != eL ? new Sample(s[i], eL) : s[i];
        }
        Sample[][] sTrainTestClassWise = new Sample[2][s.length];
        pU.setMax(repeats);
        for (int iteration = 0; iteration < repeats; ++iteration) {
            for (int classes = 0; classes < s.length; ++classes) {
                sTrainTestClassWise[0][classes] = tempS[classes].subSampling(trainN[classes]);
                sTrainTestClassWise[1][classes] = new Sample(tempS[classes].subSampling(testN[classes]), subSeqL);
            }
            this.train(sTrainTestClassWise[0]);
            this.test(mp, exceptionIfMPNotComputable, sTrainTestClassWise[1]);
            pU.setValue(iteration + 1);
            if (pU.isCancelled()) break;
        }
    }
}

