/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.classifier.scoringFunctionBased.OptimizableFunction;
import de.jstacs.classifier.scoringFunctionBased.ScoreClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.parameters.CollectionParameter;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SequenceScoringParameterSet;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreClassifierParameterSet
extends SequenceScoringParameterSet {
    private static final String[] algorithmStrings = new String[]{"steepest descent", "conjugate gradients (F., R.)", "conjugate gradients (P., R. positive)", "quasi newton (D., F., P.)", "quasi newton (B., F., G., S.)", "limited memory quasi newton (B., F., G., S.; n=3)", "limited memory quasi newton (B., F., G., S.; n=4)", "limited memory quasi newton (B., F., G., S.; n=5)", "limited memory quasi newton (B., F., G., S.; n=6)", "limited memory quasi newton (B., F., G., S.; n=7)", "limited memory quasi newton (B., F., G., S.; n=8)", "limited memory quasi newton (B., F., G., S.; n=9)", "limited memory quasi newton (B., F., G., S.; n=10)"};
    private static final Byte[] algorithms = new Byte[]{(byte)16, (byte)17, (byte)18, (byte)19, (byte)20, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10};

    public ScoreClassifierParameterSet(Class<? extends ScoreClassifier> instanceClass, boolean simple, AlphabetContainer.AlphabetContainerType type, boolean variableLength) {
        super(ScoreClassifier.class, type, simple, variableLength);
    }

    public ScoreClassifierParameterSet(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public ScoreClassifierParameterSet(Class<? extends ScoreClassifier> instanceClass, AlphabetContainer alphabet, int length, byte algo, double eps, double lineps, double startD, boolean free, OptimizableFunction.KindOfParameter kind) throws Exception {
        super(instanceClass, alphabet, length, length == 0);
        ((Parameter)this.parameters.get(0)).setValue(algorithmStrings[ScoreClassifierParameterSet.getIndex(algorithmStrings, algorithms, Byte.valueOf(algo), false)]);
        ((Parameter)this.parameters.get(1)).setValue(eps);
        ((Parameter)this.parameters.get(2)).setValue(lineps);
        ((Parameter)this.parameters.get(3)).setValue(startD);
        ((Parameter)this.parameters.get(4)).setValue(free);
        ((Parameter)this.parameters.get(5)).setValue((Object)kind);
    }

    @Override
    protected void loadParameters() throws Exception {
        this.initParameterList();
        this.parameters.add(new CollectionParameter(DataType.BYTE, algorithmStrings, algorithms, "algorithm", "the algorithm that should be used for numerical optimization", true));
        this.parameters.add(new SimpleParameter(DataType.DOUBLE, "epsilon", "the threshold for stopping the numerical training", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE)));
        this.parameters.add(new SimpleParameter(DataType.DOUBLE, "line epsilon", "the threshold for stopping the line search in the numerical training", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE)));
        this.parameters.add(new SimpleParameter(DataType.DOUBLE, "start distance", "the start distance for the line search in the numerical training", true, new NumberValidator<Double>(0.0, (Double)Double.MAX_VALUE)));
        this.parameters.add(new SimpleParameter(DataType.BOOLEAN, "free parameters", "Indicates whether only the free parameters or all parameters should be used.", true, new Boolean(true)));
        this.parameters.add(new EnumParameter(OptimizableFunction.KindOfParameter.class, "Indicates whether special plugIn parameters or the zero vector should be used as start parameters. For non-concave problems it is highly recommended to use plugIn parameters.", true));
    }

    public boolean useOnlyFreeParameter() {
        return (Boolean)this.getParameterAt(4).getValue();
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getInstanceComment() {
        return "holds the parameters for a score classifier";
    }
}

