/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased;

import de.jstacs.WrongAlphabetException;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.classifier.scoringFunctionBased.OptimizableFunction;
import de.jstacs.data.Sample;
import de.jstacs.scoringFunctions.ScoringFunction;

public abstract class AbstractOptimizableFunction
extends OptimizableFunction {
    protected int[] shortcut;
    protected Sample[] data;
    protected double[][] weights;
    protected double[] clazz;
    protected double[] logClazz;
    protected double[] sum;
    protected int cl;
    protected boolean norm;
    protected boolean freeParams;

    protected AbstractOptimizableFunction(Sample[] data, double[][] weights, boolean norm, boolean freeParams) throws IllegalArgumentException, WrongAlphabetException {
        this.norm = norm;
        this.freeParams = freeParams;
        this.shortcut = new int[data.length + 1];
        this.cl = data.length;
        if (this.cl < 1 || this.cl != weights.length) {
            throw new IllegalArgumentException("The number of classes is not correct. Check the length of the data and weights array.");
        }
        this.shortcut[0] = freeParams ? this.cl - 1 : this.cl;
        this.data = data;
        this.weights = weights;
        this.logClazz = new double[this.cl];
        this.clazz = new double[this.cl];
        this.sum = new double[this.cl + 1];
        this.sum[this.cl] = 0.0;
        for (int i = 0; i < this.cl; ++i) {
            this.sum[i] = 0.0;
            for (int j = 0; j < weights[i].length; ++j) {
                int n = i;
                this.sum[n] = this.sum[n] + weights[i][j];
            }
            int n = this.cl;
            this.sum[n] = this.sum[n] + this.sum[i];
        }
    }

    public final int getDimensionOfScope() {
        return this.shortcut[this.cl];
    }

    public abstract void getParameters(OptimizableFunction.KindOfParameter var1, double[] var2) throws Exception;

    public final double[] getParameters(OptimizableFunction.KindOfParameter kind) throws Exception {
        double[] temp = new double[this.getDimensionOfScope()];
        this.getParameters(kind, temp);
        return temp;
    }

    public void setParams(double[] params) throws DimensionException {
        if (params == null || params.length != this.shortcut[this.cl]) {
            if (params != null) {
                throw new DimensionException(params.length, this.shortcut[this.cl]);
            }
            throw new DimensionException(0, this.shortcut[this.cl]);
        }
        for (int counter1 = 0; counter1 < this.shortcut[0]; ++counter1) {
            this.logClazz[counter1] = params[counter1];
            this.clazz[counter1] = Math.exp(params[counter1]);
        }
    }

    public final double[] getClassParams(double[] params) {
        double[] res = new double[this.cl];
        System.arraycopy(params, 0, res, 0, this.shortcut[0]);
        if (this.freeParams) {
            res[this.shortcut[0]] = 0.0;
        }
        return res;
    }

    protected final int getNumberOfStarts(ScoringFunction[] score) {
        int starts = score[0].getNumberOfRecommendedStarts();
        for (int i = 1; i < score.length; ++i) {
            starts = Math.max(starts, score[i].getNumberOfRecommendedStarts());
        }
        return starts;
    }

    public final void addTermToClassParameter(int classIndex, double term) {
        if (classIndex < 0 || classIndex >= this.cl) {
            throw new IndexOutOfBoundsException("check the class index");
        }
        if (this.freeParams && classIndex == this.cl - 1) {
            for (int i = 0; i < this.shortcut[0]; ++i) {
                int n = i;
                this.logClazz[n] = this.logClazz[n] - term;
                this.clazz[i] = Math.exp(this.logClazz[i]);
            }
        } else {
            int n = classIndex;
            this.logClazz[n] = this.logClazz[n] + term;
            this.clazz[classIndex] = Math.exp(this.logClazz[classIndex]);
        }
    }
}

