/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.ByteSequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.models.discrete.ConstraintManager;
import de.jstacs.models.discrete.inhomogeneous.InhCondProb;
import de.jstacs.models.discrete.inhomogeneous.InhomogeneousDGM;
import de.jstacs.models.discrete.inhomogeneous.parameters.IDGMParameterSet;
import de.jstacs.results.NumericalResultSet;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public abstract class DAGModel
extends InhomogeneousDGM {
    protected InhCondProb[] constraints;

    protected DAGModel(IDGMParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    protected DAGModel(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public DAGModel clone() throws CloneNotSupportedException {
        DAGModel clone = (DAGModel)super.clone();
        if (this.constraints != null) {
            clone.constraints = (InhCondProb[])ArrayHandler.clone((Cloneable[])this.constraints);
        }
        return clone;
    }

    public Sample emitSample(int n, int ... lengths) throws NotTrainedException, Exception {
        int counter2;
        if (lengths != null && lengths.length != 0) {
            throw new Exception("This is an inhomogeneous model. Please check parameter lengths.");
        }
        if (!this.trained) {
            throw new NotTrainedException();
        }
        boolean[] visited = new boolean[this.length];
        int[] order = new int[this.length];
        int counter1 = 0;
        int index = 0;
        Arrays.fill(visited, false);
        for (counter1 = 0; counter1 < this.length; ++counter1) {
            if (this.constraints[counter1].getMarginalOrder() != 1) continue;
            visited[counter1] = true;
            order[index++] = counter1;
        }
        while (index < this.length) {
            for (counter1 = 0; counter1 < this.length; ++counter1) {
                if (visited[counter1]) continue;
                int l = this.constraints[counter1].getMarginalOrder() - 1;
                for (counter2 = 0; counter2 < l && visited[this.constraints[counter1].getPosition(counter2)]; ++counter2) {
                }
                if (counter2 != l) continue;
                order[index++] = counter1;
                visited[counter1] = true;
            }
        }
        byte[] content = new byte[this.length];
        Sequence[] s = new Sequence[n];
        Random r = new Random();
        for (counter1 = 0; counter1 < n; ++counter1) {
            for (counter2 = 0; counter2 < this.length; ++counter2) {
                this.constraints[order[counter2]].getOutput(content, r.nextDouble());
            }
            s[counter1] = new ByteSequence(this.alphabets, content);
        }
        return new Sample("sampled from " + this.getInstanceName(), s);
    }

    public double getLogPriorTerm() throws Exception {
        double p = 0.0;
        double ess = this.getESS();
        if (ess > 0.0) {
            if (!this.trained) {
                throw new NotTrainedException();
            }
            for (int counter1 = 0; counter1 < this.length; ++counter1) {
                int anz1 = this.constraints[counter1].getNumberOfSpecificConstraints();
                double pot = ess / (double)anz1;
                double anz2 = this.alphabetLength[this.constraints[counter1].getPosition(this.constraints[counter1].getMarginalOrder() - 1)];
                p += (double)anz1 / anz2 * Gamma.logOfGamma((double)(anz2 * pot)) - (double)anz1 * Gamma.logOfGamma((double)pot);
                for (int counter2 = 0; counter2 < anz1; ++counter2) {
                    p += pot * this.constraints[counter1].getLnFreq(counter2);
                }
            }
            return p;
        }
        return 0.0;
    }

    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        this.check(sequence, startpos, endpos);
        double erg = this.constraints[0].getLnFreq(sequence, startpos);
        for (int i = 1; i < this.length; ++i) {
            erg += this.constraints[i].getLnFreq(sequence, startpos);
        }
        return erg;
    }

    public NumericalResultSet getNumericalCharacteristics() {
        return null;
    }

    public double getProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        this.check(sequence, startpos, endpos);
        double erg = this.constraints[0].getFreq(sequence, startpos);
        for (int i = 1; i < this.length; ++i) {
            erg *= this.constraints[i].getFreq(sequence, startpos);
        }
        return erg;
    }

    public String getStructure() throws NotTrainedException {
        if (this.trained) {
            StringBuffer all;
            if (this.getMaximalMarkovOrder() == 0) {
                all = new StringBuffer(5000);
                for (int counter1 = 0; counter1 < this.constraints.length; ++counter1) {
                    all.append(this.constraints[counter1].toString());
                    for (int counter2 = 0; counter2 < this.constraints[counter1].getNumberOfSpecificConstraints(); ++counter2) {
                        all.append("\t" + this.alphabets.getSymbol(this.constraints[counter1].getPosition(0), counter2) + ": " + this.constraints[counter1].getFreq(counter2));
                    }
                    all.append("\n");
                }
            } else {
                all = new StringBuffer(500);
                for (int counter1 = 0; counter1 < this.constraints.length; ++counter1) {
                    all.append(this.constraints[counter1].toString() + "\n");
                }
            }
            return all.toString();
        }
        throw new NotTrainedException();
    }

    public String toString() {
        String erg = "description: " + this.getDescription();
        if (this.trained) {
            try {
                erg = erg + "\n" + this.getStructure();
            }
            catch (NotTrainedException impossible) {
                System.exit(1);
            }
        }
        return erg;
    }

    protected static boolean checkAcyclic(int length, int[][] graph) {
        ArrayList<int[]> edges = new ArrayList<int[]>(length);
        int counter1 = 0;
        boolean[] used = new boolean[length];
        boolean changed = false;
        Arrays.fill(used, false);
        while (counter1 < length) {
            if (graph[counter1].length > 1) {
                edges.add(graph[counter1++]);
                continue;
            }
            used[counter1++] = true;
            changed = true;
        }
        while (edges.size() > 0 && changed) {
            changed = false;
            counter1 = 0;
            while (counter1 < edges.size()) {
                int counter2;
                int[] help = (int[])edges.get(counter1);
                for (counter2 = 0; counter2 < help.length - 1 && used[help[counter2]]; ++counter2) {
                }
                if (counter2 == help.length - 1) {
                    used[help[help.length - 1]] = true;
                    changed = true;
                    edges.remove(counter1);
                    continue;
                }
                ++counter1;
            }
        }
        return edges.size() == 0;
    }

    protected void createConstraints(int[][] structure) {
        this.constraints = new InhCondProb[this.length];
        for (int i = 0; i < this.length; ++i) {
            this.constraints[i] = new InhCondProb(structure[i], this.alphabetLength, structure[i].length > 1);
        }
    }

    protected void drawParameters(Sample data, double[] weights) throws Exception {
        if (data != null) {
            ConstraintManager.countInhomogeneous(this.alphabets, this.length, data, weights, true, this.constraints);
        }
        ConstraintManager.drawFreqs(this.getESS(), this.constraints);
        this.trained = true;
    }

    protected void estimateParameters(Sample data, double[] weights) throws Exception {
        ConstraintManager.countInhomogeneous(this.alphabets, this.length, data, weights, true, this.constraints);
        ConstraintManager.computeFreqs(this.getESS(), this.constraints);
        this.trained = true;
    }

    protected StringBuffer getFurtherModelInfos() {
        if (this.trained) {
            StringBuffer xml = new StringBuffer(10000);
            XMLParser.appendStorableArrayWithTags(xml, this.constraints, "conditionalProb");
            return xml;
        }
        return null;
    }

    protected void setFurtherModelInfos(StringBuffer xml) throws NonParsableException {
        if (this.trained) {
            this.constraints = (InhCondProb[])ArrayHandler.cast(XMLParser.extractStorableArrayForTag(xml, "conditionalProb"));
        }
    }
}

