/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier;

import de.jstacs.classifier.ScoreBasedPerformanceMeasureDefinitions;
import de.jstacs.utils.DoubleList;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;

public class Classification {
    private static double[] getSortedValues(String fName) throws Exception {
        String line;
        BufferedReader r = new BufferedReader(new FileReader(fName));
        DoubleList dlist = new DoubleList();
        while ((line = r.readLine()) != null) {
            dlist.add(Double.parseDouble(line));
        }
        r.close();
        double[] res = dlist.toArray();
        Arrays.sort(res);
        return res;
    }

    public static void main(String[] args) throws Exception {
        double[] fg = Classification.getSortedValues(args[0]);
        double[] bg = Classification.getSortedValues(args[1]);
        ScoreBasedPerformanceMeasureDefinitions.ThresholdMeasurePair tmp = ScoreBasedPerformanceMeasureDefinitions.getSensitivityForSpecificity(fg, bg, 0.999);
        System.out.println("Sn (with Sp=99.9%) =\t" + tmp.getMeasure() + "\tthreshold =\t" + tmp.getThreshold());
        tmp = ScoreBasedPerformanceMeasureDefinitions.getFPRForSensitivity(fg, bg, 0.95);
        System.out.println("FPR (with Sn=95%) =\t" + tmp.getMeasure() + "\tthreshold =\t" + tmp.getThreshold());
        tmp = ScoreBasedPerformanceMeasureDefinitions.getPPVForSensitivity(fg, bg, 0.95);
        System.out.println("PPV with Sn=95%\t" + tmp.getMeasure() + "\tthreshold =\t" + tmp.getThreshold());
        System.out.println("AUC_ROC\t" + ScoreBasedPerformanceMeasureDefinitions.getAUC_ROC(fg, bg, null));
        System.out.println("AUC_PR\t" + ScoreBasedPerformanceMeasureDefinitions.getAUC_PR(fg, bg, null));
    }
}

