/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.geometry.geodesic;

public class DoubleVectorList {
    double[][] data;
    int size;
    final int dim;

    public DoubleVectorList(int n, int n2) {
        this.data = new double[n2][n];
        this.size = 0;
        this.dim = n;
    }

    public DoubleVectorList(int n) {
        this(n, 100);
    }

    public DoubleVectorList(double[][] dArray) {
        this.size = dArray.length;
        this.dim = dArray[0].length;
        this.data = new double[dArray.length + (dArray.length + 10) / 2][this.dim];
        System.arraycopy(dArray, 0, this.data, 0, this.size);
    }

    public int size() {
        return this.size;
    }

    public int capacity() {
        return this.data.length;
    }

    public double[] get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        return this.data[n];
    }

    public double[] getNewLast() {
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        return this.data[this.size++];
    }

    public void set(int n, double[] dArray) {
        if (n < 0 || n > this.size || dArray.length != this.dim) {
            throw new IllegalArgumentException("index out of range");
        }
        if (dArray.length != this.dim) {
            throw new IllegalArgumentException("vector has wrong dimension");
        }
        if (this.size == n) {
            if (this.size == this.data.length) {
                this.setCapacity(this.data.length + (this.data.length + 10) / 2);
            }
            this.data[this.size++] = dArray;
        }
        this.data[n] = dArray;
    }

    public void add(double[] dArray) {
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        this.data[this.size++] = dArray;
    }

    public void remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        System.arraycopy(this.data, n + 1, this.data, n, this.size - n - 1);
        this.data[this.data.length - 1] = new double[this.dim];
        --this.size;
    }

    public void insert(int n, double[] dArray) {
        if (n < 0 || n > this.size) {
            throw new IllegalArgumentException("index out of range");
        }
        if (dArray.length != this.dim) {
            throw new IllegalArgumentException("vector has wrong dimension");
        }
        if (this.size == this.data.length) {
            this.setCapacity(this.data.length + (this.data.length + 10) / 2);
        }
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = dArray;
        ++this.size;
    }

    public void setCapacity(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException("capacity must exeed size of list");
        }
        double[][] dArrayArray = new double[n][];
        System.arraycopy(this.data, 0, dArrayArray, 0, Math.min(dArrayArray.length, this.data.length));
        for (int i = this.data.length; i < dArrayArray.length; ++i) {
            dArrayArray[i] = new double[this.dim];
        }
        this.data = dArrayArray;
    }

    public void removeAll() {
        this.size = 0;
    }

    void appendVector(double[] dArray, StringBuffer stringBuffer) {
        stringBuffer.append("(");
        if (this.size > 0) {
            stringBuffer.append(this.data[0]);
            for (int i = 1; i < this.size; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(this.data[i]);
            }
        }
        stringBuffer.append(')');
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("(");
        if (this.size > 0) {
            stringBuffer.append(this.data[0]);
            for (int i = 1; i < this.size; ++i) {
                stringBuffer.append(", ");
                this.appendVector(this.data[i], stringBuffer);
            }
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }
}

