/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.seq.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.SequenceIterator;
import org.biojavax.Namespace;
import org.biojavax.bio.seq.io.RichSequenceFormat;

public class RichStreamWriter {
    private RichSequenceFormat format;
    private PrintStream os;

    public void writeStream(SequenceIterator ss, Namespace ns) throws IOException {
        this.format.setPrintStream(this.os);
        this.format.beginWriting();
        while (ss.hasNext()) {
            try {
                this.format.writeSequence(ss.nextSequence(), ns);
            }
            catch (BioException se) {
                se.printStackTrace();
            }
        }
        this.format.finishWriting();
    }

    public RichStreamWriter(OutputStream os, RichSequenceFormat format) {
        this.os = new PrintStream(os);
        this.format = format;
    }
}

