/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs;

/**
 * A WrongAlphabetException is thrown if a data file did not match the given
 * alphabet.
 * 
 * @author Jan Grau
 */
public class WrongAlphabetException extends Exception
{
	private static final long serialVersionUID = 3257008769530474547L;

	/**
	 * Creates a new WrongAlphabetException with standard message (&quot;The data of the selected file does not match the entered alphabet.&quot;).
	 */
	public WrongAlphabetException()
	{
		super( "The data of the selected file does not match the entered alphabet." );
	}

	/**
	 * Creates a new WrongAlphabetException with your own <code>message</code>.
	 * 
	 * @param message the message
	 */
	public WrongAlphabetException( String message )
	{
		super( message );
	}
}