/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.scoringFunctions.homogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.scoringFunctions.VariableLengthScoringFunction;

/**
 * This is the main class for all homogeneous ScoringFunctions. 
 * 
 * @author Jens Keilwagen
 */
public abstract class HomogeneousScoringFunction extends VariableLengthScoringFunction
{

	/**
	 * This is the main constructor that creates an instance that models sequence s of arbitrary length.
	 * 
	 * @param alphabets the AlphabetContainer
	 */
	protected HomogeneousScoringFunction( AlphabetContainer alphabets )
	{
		super( alphabets );
	}
	
	/**
	 * This is the main constructor that creates an instance that models sequence s of a given length.
	 * 
	 * @param alphabets the AlphabetContainer
	 * @param length the length of the modeled sequences
	 */
	protected HomogeneousScoringFunction( AlphabetContainer alphabets, int length )
	{
		super( alphabets, length );
	}

	/**
	 * This is the constructor for {@link de.jstacs.Storable}.
	 * 
	 * @param source the xml representation
	 * 
	 * @throws NonParsableException if the representation could not be parsed.
	 */
	protected HomogeneousScoringFunction( StringBuffer source ) throws NonParsableException
	{
		super( source );
	}
	
	/**
	 * Returns the maximal used markov oder.
	 * 
	 * @return the maximal used markov oder
	 */
	public abstract int getMaximalMarkovOrder();
}
