/*
 * This file is part of Jstacs.
 *
 * Jstacs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Jstacs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Jstacs.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * For more information on Jstacs, visit http://www.jstacs.de
 */

package de.jstacs.results;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;

import java.util.LinkedList;

/**
 * Class for a set of numerical result values, which are all of the type <code>NumericalResult</code>.
 * @author Jan Grau
 *
 */
public class NumericalResultSet extends ResultSet {

	/**
	 * Constructs a <code>NumericalResultSet</code> containing one <code>NumericalResult</code>.
	 * @param result the result to be contained
	 */
	public NumericalResultSet(NumericalResult result){
		super(result);
	}
	
	/**
	 * Constructs a <code>NumericalResultSet</code> from an array of <code>NumericalResult</code>s.
	 * @param results the results
	 */
	public NumericalResultSet(NumericalResult[]... results){
		super(results);
	}
	
	/**
	 * Constructs a <code>NumericalResultSet</code> from a  LinkedList of <code>NumericalResult</code>s.
	 * @param results the LikedList of <code>NumericalResult</code>s
	 */
	public NumericalResultSet
	(LinkedList<? extends NumericalResult> results){
	super(results);
	}
	
	/**
	 * This is the constructor for {@link Storable}.
	 * 
	 * @param representation the xml representation
	 * 
	 * @throws NonParsableException if the representation could not be parsed.
	 */
    public NumericalResultSet(StringBuffer representation) throws NonParsableException{
        super(representation);
    }
    
	/**
	 * Returns the <code>NumericalResult</code> number </code>index</code>.
	 * @return the result
	 */
	public NumericalResult getResultAt(int index){
		return (NumericalResult) results[index];
	}
}
