/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.results;

import de.jstacs.fx.renderers.results.ResultRenderer;
import de.jstacs.fx.renderers.results.ResultRendererLibrary;
import de.jstacs.results.PlotGeneratorResult;
import de.jstacs.utils.graphics.GraphicsAdaptor;
import de.jstacs.utils.graphics.RasterizedAdaptor;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;

public class PlotGeneratorResultRenderer
implements ResultRenderer<PlotGeneratorResult> {
    private HashMap<Object, WritableImage> map = new HashMap();

    public static void register() {
        ResultRendererLibrary.register(PlotGeneratorResult.class, new PlotGeneratorResultRenderer());
    }

    private PlotGeneratorResultRenderer() {
    }

    @Override
    public Node render(PlotGeneratorResult result, final Pane parent) {
        try {
            WritableImage img2 = null;
            if (result.isStatic() && this.map.containsKey(result)) {
                img2 = this.map.get(result);
            } else {
                RasterizedAdaptor ra = new RasterizedAdaptor("png");
                result.getValue().generatePlot((GraphicsAdaptor)ra);
                BufferedImage im = ra.getImage();
                img2 = SwingFXUtils.toFXImage((BufferedImage)im, null);
                if (result.isStatic()) {
                    this.map.put(result, img2);
                }
            }
            final WritableImage img = img2;
            final ImageView view = new ImageView((Image)img);
            view.setCache(false);
            view.setSmooth(true);
            view.setPreserveRatio(true);
            ScrollPane pane = new ScrollPane((Node)view);
            final HBox bar = new HBox(20.0);
            Button plus = new Button("+");
            plus.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    view.setFitWidth(view.getFitWidth() * 1.1);
                    view.setFitHeight(-1.0);
                }
            });
            Button minus = new Button("-");
            minus.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    view.setFitWidth(view.getFitWidth() / 1.1);
                    view.setFitHeight(-1.0);
                }
            });
            Button fit = new Button("Fit");
            fit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    double ratw = (parent.getWidth() - 5.0) / img.getWidth();
                    double rath = (parent.getHeight() - bar.getHeight() - 5.0) / img.getHeight();
                    double rat = Math.min(ratw, rath);
                    view.setFitWidth(img.getWidth() * rat);
                    view.setFitHeight(img.getHeight() * rat);
                }
            });
            Button fitw = new Button("Fit width");
            fitw.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    double ratw = (parent.getWidth() - 5.0) / img.getWidth();
                    double rath = (parent.getHeight() - bar.getHeight() - 5.0) / img.getHeight();
                    view.setFitWidth(parent.getWidth() - 5.0 - (double)(rath < ratw ? 15 : 0));
                    view.setFitHeight(-1.0);
                }
            });
            Button fith = new Button("Fit height");
            fith.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent arg0) {
                    double ratw = (parent.getWidth() - 5.0) / img.getWidth();
                    double rath = (parent.getHeight() - bar.getHeight() - 5.0) / img.getHeight();
                    view.setFitWidth(-1.0);
                    view.setFitHeight(parent.getHeight() - bar.getHeight() - 5.0 - (double)(ratw < rath ? 15 : 0));
                }
            });
            bar.getChildren().addAll((Object[])new Node[]{plus, minus, fit, fitw, fith});
            BorderPane both = new BorderPane();
            both.setTop((Node)bar);
            both.setCenter((Node)pane);
            double ratw = (parent.getWidth() - 5.0) / img.getWidth();
            double rath = (parent.getHeight() - 30.0) / img.getHeight();
            double rat = Math.min(ratw, rath);
            view.setFitWidth(img.getWidth() * rat);
            view.setFitHeight(img.getHeight() * rat);
            return both;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

