/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.fx.renderers.parameters;

import de.jstacs.fx.Application;
import de.jstacs.fx.LoadSaveDialogs;
import de.jstacs.fx.renderers.parameters.AbstractParameterRenderer;
import de.jstacs.fx.renderers.parameters.ParameterRendererLibrary;
import de.jstacs.fx.repository.ResultRepository;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSetResult;
import de.jstacs.results.TextResult;
import de.jstacs.results.savers.ResultSaver;
import de.jstacs.results.savers.ResultSaverLibrary;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;

public class FileParameterRenderer
extends AbstractParameterRenderer<FileParameter> {
    public static void register() {
        ParameterRendererLibrary.register(FileParameter.class, new FileParameterRenderer());
    }

    public static ChoiceBox getBox(FileParameter parameter) {
        ArrayList<ResultRepository.ResultConsumer> consumers = ResultRepository.getInstance().getConsumers();
        for (int i = 0; i < consumers.size(); ++i) {
            ResultRepository.ResultConsumer cons = consumers.get(i);
            if (!(cons instanceof FileResultConsumer) || ((FileResultConsumer)cons).parameter != parameter) continue;
            return ((FileResultConsumer)cons).box;
        }
        return null;
    }

    private FileParameterRenderer() {
    }

    private static ResultContainer[] getItems(FileParameter parameter) {
        List<Result> files = ResultRepository.getInstance().filterByMimeAndExtendedType(parameter.getAcceptedMimeType(), null);
        ResultContainer[] items = new ResultContainer[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            items[i] = new ResultContainer(files.get(i));
        }
        return items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromFile(FileParameter parameter, ChoiceBox<ResultContainer> box, Label error, Application.ToolReady ready) {
        String[] ft = parameter.getAcceptedMimeType().split("\\,");
        for (int i = 0; i < ft.length; ++i) {
            ft[i] = "*." + ft[i];
        }
        File f = LoadSaveDialogs.showLoadDialog(Application.mainWindow, parameter.getAcceptedMimeType().toUpperCase(), ft);
        if (f == null) {
            return;
        }
        FileParameter.FileRepresentation fr = new FileParameter.FileRepresentation(f.getAbsolutePath());
        TextResult fres = new TextResult(f.getName(), "", fr, parameter.getAcceptedMimeType(), "Loaded from file", parameter.getExtendedType(), false);
        try {
            fres.fill(parameter);
            ResultRepository.getInstance().add((Result)fres);
            box.getSelectionModel().select((Object)new ResultContainer((Result)fres));
        }
        catch (SimpleParameter.IllegalValueException e) {
            e.printStackTrace();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        finally {
            ready.testReady();
            error.setText(parameter.getErrorMessage());
        }
    }

    @Override
    protected void addInputs(final FileParameter parameter, Pane parent, Label name, Node comment, final Label error, final Application.ToolReady ready) {
        Object[] items = FileParameterRenderer.getItems(parameter);
        final ChoiceBox box = new ChoiceBox();
        ObservableList ilist = FXCollections.observableArrayList((Object[])items);
        ilist.add(0, (Object)new ResultContainer(null));
        box.setItems(ilist);
        parent.getChildren().add((Object)box);
        box.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ResultContainer>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void changed(ObservableValue<? extends ResultContainer> arg0, ResultContainer arg1, ResultContainer arg2) {
                try {
                    if (arg2 == null) {
                        parameter.reset();
                    } else if (arg2.res instanceof TextResult) {
                        ((TextResult)arg2.res).fill(parameter);
                    } else if (arg2.getFileRepresentation() != null) {
                        parameter.setValue((Object)arg2.getFileRepresentation());
                    }
                }
                catch (SimpleParameter.IllegalValueException e) {
                    e.printStackTrace();
                }
                catch (CloneNotSupportedException ex) {
                    ex.printStackTrace();
                }
                finally {
                    ready.testReady();
                    error.setText(parameter.getErrorMessage());
                }
            }
        });
        if (parameter.getFileContents() != null) {
            String filename = parameter.getFileContents().getFilename();
            boolean found = false;
            if (filename != null && filename.length() > 0) {
                for (int i = 0; i < items.length && !found; ++i) {
                    FileParameter.FileRepresentation temp = ((ResultContainer)items[i]).getFileRepresentation();
                    if (temp == null || !filename.equals(temp.getFilename())) continue;
                    box.getSelectionModel().select(items[i]);
                    found = true;
                    break;
                }
            }
            if (!found) {
                String contents = parameter.getFileContents().getContent();
                for (int i = 0; i < items.length; ++i) {
                    FileParameter.FileRepresentation temp = ((ResultContainer)items[i]).getFileRepresentation();
                    if (temp == null || !contents.equals(temp.getContent())) continue;
                    box.getSelectionModel().select(items[i]);
                    found = true;
                    break;
                }
            }
            if (!found) {
                error.setText("Previous file \"" + filename + "\" not found in repository.");
            }
        }
        ResultRepository.getInstance().register(new FileResultConsumer(parameter, (ChoiceBox<ResultContainer>)box));
        Button but = new Button("Load from file...");
        parent.getChildren().add((Object)but);
        but.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent actionEvent) {
                FileParameterRenderer.this.loadFromFile(parameter, (ChoiceBox<ResultContainer>)box, error, ready);
                ready.testReady();
            }
        });
    }

    private static class FileResultConsumer
    implements ResultRepository.ResultConsumer {
        private FileParameter parameter;
        private ChoiceBox<ResultContainer> box;

        public FileResultConsumer(FileParameter parameter, ChoiceBox<ResultContainer> box) {
            this.parameter = parameter;
            this.box = box;
        }

        public ChoiceBox getBox() {
            return this.box;
        }

        @Override
        public void notifyAdded(Result added) {
            LinkedList<ResultContainer> li = new LinkedList<ResultContainer>();
            this.collectForModification(added, li);
            this.box.getItems().addAll(li);
        }

        private void collectForModification(Result result, LinkedList<ResultContainer> toModify) {
            if (result instanceof TextResult && TextResult.equals((String)this.parameter.getAcceptedMimeType(), (String)((TextResult)result).getMime())) {
                toModify.add(new ResultContainer((Result)((TextResult)result)));
            } else if (result instanceof ResultSetResult) {
                Result[] temp = ((ResultSetResult)result).getRawResult()[0].getResults();
                for (int i = 0; i < temp.length; ++i) {
                    this.collectForModification(temp[i], toModify);
                }
            } else {
                String[] exts;
                ResultSaver saver = ResultSaverLibrary.getSaver(result.getClass());
                if (saver != null && TextResult.equals((String[])(exts = saver.getFileExtensions(result)), (String)this.parameter.getAcceptedMimeType())) {
                    toModify.add(new ResultContainer(result));
                }
            }
        }

        @Override
        public void notifyRemoved(Result removed) {
            LinkedList<ResultContainer> li = new LinkedList<ResultContainer>();
            this.collectForModification(removed, li);
            this.box.getItems().removeAll(li);
        }

        @Override
        public void notifyRefresh(Result renamed) {
            if (!this.box.getItems().isEmpty()) {
                this.box.getItems().set(0, this.box.getItems().get(0));
            }
        }
    }

    private static class ResultContainer {
        private Result res;
        private FileParameter.FileRepresentation frint2;

        public ResultContainer(Result fr) {
            this.res = fr;
        }

        public FileParameter.FileRepresentation getFileRepresentation() {
            if (this.frint2 == null && this.res != null) {
                if (this.res instanceof TextResult) {
                    this.frint2 = ((TextResult)this.res).getValue();
                } else {
                    ResultSaver saver = ResultSaverLibrary.getSaver(this.res.getClass());
                    if (saver != null) {
                        StringBuffer sb = new StringBuffer();
                        saver.writeOutput(this.res, sb);
                        this.frint2 = new FileParameter.FileRepresentation("", sb.toString());
                        this.frint2.setExtension(saver.getFileExtensions(this.res)[0]);
                    }
                }
            }
            return this.frint2;
        }

        public String toString() {
            if (this.res == null) {
                return "--- None ---";
            }
            return this.res.getName();
        }

        public boolean equals(Object other) {
            if (other instanceof ResultContainer && this.res != null) {
                return this.res.equals(((ResultContainer)other).res);
            }
            return false;
        }
    }
}

