/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import java.io.IOException;
import java.util.Random;

public class UnivariateRandomGenerator {
    public static double equalDistributed() {
        return UnivariateRandomGenerator.equalDistributed(new Random());
    }

    private static double equalDistributed(Random r) {
        return r.nextDouble();
    }

    public static double exponentialDistributed() {
        return UnivariateRandomGenerator.exponentialDistributed(new Random());
    }

    private static double exponentialDistributed(Random r) {
        return -Math.log(1.0 - UnivariateRandomGenerator.equalDistributed(r));
    }

    public static double erlangDistributed(int alpha) throws IOException {
        if (alpha < 1) {
            throw new IOException("Only possible for alpha > 0");
        }
        return UnivariateRandomGenerator.erlangDistributed(alpha, new Random());
    }

    public static double erlangDistributed(int alpha, Random r) {
        double erg = UnivariateRandomGenerator.exponentialDistributed(r);
        for (int i = 1; i < alpha; ++i) {
            erg += UnivariateRandomGenerator.exponentialDistributed(r);
        }
        return erg;
    }
}

