/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils.random;

import de.jstacs.utils.random.ErlangMRGParams;
import de.jstacs.utils.random.MRGParams;
import de.jstacs.utils.random.MultivariateRandomGenerator;
import de.jstacs.utils.random.UnivariateRandomGenerator;
import java.util.Random;

public class ErlangMRG
extends MultivariateRandomGenerator {
    private Random r = new Random();

    public void generate(double[] d, int start, int n, MRGParams p) {
        int i;
        ErlangMRGParams param = (ErlangMRGParams)p;
        if (param.getDimension() != n) {
            throw new IllegalArgumentException("Hyperparameter doesnot have a correct dimension.");
        }
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            d[start + i] = UnivariateRandomGenerator.erlangDistributed(param.getHyperparameter(i), this.r);
            sum += d[start + i];
        }
        i += start;
        while (start < i) {
            int n2 = start++;
            d[n2] = d[n2] / sum;
        }
    }
}

