/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.btMeasures;

import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.MST;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class BTMutualInformation
extends Measure {
    private int clazz;
    private double[] ess;
    public static final int FG = 0;
    public static final int BG = 1;
    public static final int BOTH = 2;

    public BTMutualInformation(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "btMutualInformation");
        this.clazz = XMLParser.extractIntForTag(buf, "clazz");
        this.ess = XMLParser.extractDoubleArrayForTag(buf, "ess");
    }

    public BTMutualInformation(int clazz, double[] ess) throws Exception {
        if (clazz != 0 && clazz != 1 && clazz != 2) {
            throw new Exception("Value of clazz not allowed.");
        }
        this.clazz = clazz;
        this.ess = (double[])ess.clone();
    }

    public BTMutualInformation clone() throws CloneNotSupportedException {
        BTMutualInformation clone = (BTMutualInformation)super.clone();
        clone.ess = (double[])this.ess.clone();
        return clone;
    }

    public String getInstanceName() {
        String str = "Bayesian tree with mutual information of";
        if (this.clazz == 0) {
            return str + " foreground";
        }
        if (this.clazz == 1) {
            return str + " background";
        }
        return str + " foreground and background";
    }

    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        int i;
        Sample data = null;
        double[] weights = null;
        double ess2 = 0.0;
        if (this.clazz == 0) {
            data = fg;
            weights = weightsFg;
            ess2 = this.ess[0];
        } else if (this.clazz == 1) {
            data = bg;
            weights = weightsBg;
            ess2 = this.ess[1];
        } else {
            data = Sample.union(fg, bg);
            weights = BTMutualInformation.union(new double[][]{weightsFg, weightsBg});
            ess2 = this.ess[0] + this.ess[1];
        }
        double[][][][] stat = BTMutualInformation.getStatistics(data, weights, length, ess2);
        double[][] mi = BTMutualInformation.getMI(stat, BTMutualInformation.sum(weights) + ess2);
        int[][] p = null;
        p = MST.kruskal(mi);
        int[][] parents = new int[length][1];
        for (i = 0; i < parents.length; ++i) {
            parents[i][0] = i;
        }
        for (i = 0; i < p.length; ++i) {
            int idx = p[i][1];
            parents[idx] = new int[2];
            parents[idx][0] = p[i][0];
            parents[idx][1] = idx;
        }
        return parents;
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendIntWithTags(buf, this.clazz, "clazz");
        XMLParser.appendDoubleArrayWithTags(buf, this.ess, "ess");
        XMLParser.addTags(buf, "btMutualInformation");
        return buf;
    }
}

