/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.btMeasures;

import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.MST;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.directedGraphicalModels.structureLearning.measures.Measure;

public class BTExplainingAwayResidual
extends Measure {
    private double[] ess;

    public BTExplainingAwayResidual(double[] ess) {
        this.ess = ess;
    }

    public BTExplainingAwayResidual(StringBuffer buf) throws NonParsableException {
        buf = XMLParser.extractForTag(buf, "btExplainingAwayResidual");
        this.ess = XMLParser.extractDoubleArrayForTag(buf, "ess");
    }

    public BTExplainingAwayResidual clone() throws CloneNotSupportedException {
        BTExplainingAwayResidual clone = (BTExplainingAwayResidual)super.clone();
        clone.ess = (double[])this.ess.clone();
        return clone;
    }

    public String getInstanceName() {
        return "Bayesian tree with explaining away residual";
    }

    public int[][] getParents(Sample fg, Sample bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        int i;
        double[][][][] statFg = BTExplainingAwayResidual.getStatistics(fg, weightsFg, length, this.ess[0]);
        double[][][][] statBg = BTExplainingAwayResidual.getStatistics(bg, weightsBg, length, this.ess[1]);
        double nFg = BTExplainingAwayResidual.sum(weightsFg) + this.ess[0];
        double nBg = BTExplainingAwayResidual.sum(weightsBg) + this.ess[1];
        double[][] ear = BTExplainingAwayResidual.getEAR(statFg, statBg, nFg, nBg);
        int[][] p = MST.kruskal(ear);
        int[][] parents = new int[length][1];
        for (i = 0; i < parents.length; ++i) {
            parents[i][0] = i;
        }
        for (i = 0; i < p.length; ++i) {
            int idx = p[i][1];
            parents[idx] = new int[2];
            parents[idx][0] = p[i][0];
            parents[idx][1] = idx;
        }
        return parents;
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendDoubleArrayWithTags(buf, this.ess, "ess");
        XMLParser.addTags(buf, "btExplainingAwayResidual");
        return buf;
    }
}

