/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters.validation;

import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.validation.Constraint;

public class SimpleStaticConstraint
implements Constraint {
    private int comparisonOperator;
    private Object reference;
    private String errorMessage;

    public SimpleStaticConstraint(Number reference, int comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
        this.reference = reference;
    }

    public SimpleStaticConstraint(String reference, int comparisonOperator) {
        this.comparisonOperator = comparisonOperator;
        this.reference = reference;
    }

    public SimpleStaticConstraint(StringBuffer representation) throws NonParsableException {
        this.fromXML(representation);
    }

    public SimpleStaticConstraint clone() throws CloneNotSupportedException {
        if (this.reference instanceof String) {
            SimpleStaticConstraint clone = new SimpleStaticConstraint((String)this.reference, this.comparisonOperator);
            clone.errorMessage = this.errorMessage;
            return clone;
        }
        if (this.reference instanceof Number) {
            SimpleStaticConstraint clone = new SimpleStaticConstraint((Number)this.reference, this.comparisonOperator);
            clone.errorMessage = this.errorMessage;
            return clone;
        }
        throw new CloneNotSupportedException("Reference was of non-expected type!");
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean check(Object value) {
        if (value == null) {
            this.errorMessage = "Value was null";
            return false;
        }
        if (this.comparisonOperator == 1) {
            if (!this.reference.equals(value)) {
                this.errorMessage = "Value must be equal to " + this.reference.toString();
                return false;
            }
        } else {
            if (this.comparisonOperator != 2 && this.comparisonOperator != 3 && this.comparisonOperator != 4 && this.comparisonOperator != 5) {
                this.errorMessage = "Wrong comparison operator";
                return false;
            }
            if (!(value instanceof Comparable)) {
                this.errorMessage = "Both values must be comparable";
                return false;
            }
            if (this.comparisonOperator == 2 && ((Comparable)value).compareTo(this.reference) >= 0) {
                this.errorMessage = "Value must be less than " + this.reference.toString();
                return false;
            }
            if (this.comparisonOperator == 3 && ((Comparable)value).compareTo(this.reference) <= 0) {
                this.errorMessage = "Value must be greater than " + this.reference.toString();
                return false;
            }
            if (this.comparisonOperator == 4 && ((Comparable)value).compareTo(this.reference) > 0) {
                this.errorMessage = "Value must be less than or equal to " + this.reference.toString();
                return false;
            }
            if (this.comparisonOperator == 5 && ((Comparable)value).compareTo(this.reference) < 0) {
                this.errorMessage = "Value must be greater than or equal to " + this.reference.toString();
                return false;
            }
        }
        this.errorMessage = null;
        return true;
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        XMLParser.appendStringWithTags(buf, this.reference.getClass().getName(), "className");
        XMLParser.appendStringWithTags(buf, this.reference.toString(), "value");
        XMLParser.addTags(buf, "reference");
        XMLParser.appendIntWithTags(buf, this.comparisonOperator, "comparisonOperator");
        XMLParser.appendStringWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.addTags(buf, "simpleStaticConstraint");
        return buf;
    }

    public void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "simpleStaticConstraint");
        StringBuffer ref = XMLParser.extractForTag(representation, "reference");
        try {
            Class<?> refClass = Class.forName(XMLParser.extractStringForTag(ref, "className"));
            this.reference = refClass.getConstructor(String.class).newInstance(XMLParser.extractStringForTag(ref, "value"));
        }
        catch (Exception e) {
            throw new NonParsableException(e.getMessage());
        }
        this.comparisonOperator = XMLParser.extractIntForTag(representation, "comparisonOperator");
        this.errorMessage = XMLParser.extractStringForTag(representation, "errorMessage");
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

