/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.CollectionParameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.RangeIterator;
import de.jstacs.parameters.SimpleParameter;

public class MultiSelectionCollectionParameter
extends CollectionParameter
implements RangeIterator {
    private boolean[] selected;
    private boolean[] defaultSelected;
    private int current;
    private boolean ranged;

    public MultiSelectionCollectionParameter(DataType datatype, String[] keys, Object[] values, String name, String comment, boolean required) throws CollectionParameter.InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        super(datatype, keys, values, name, comment, required);
        this.selected = new boolean[keys.length];
        this.defaultSelected = (boolean[])this.selected.clone();
        this.setValue(new String[]{keys[0]});
    }

    public MultiSelectionCollectionParameter(DataType datatype, String[] keys, Object[] values, String[] comments, String name, String comment, boolean required) throws CollectionParameter.InconsistentCollectionException, SimpleParameter.IllegalValueException, SimpleParameter.DatatypeNotValidException {
        super(datatype, keys, values, comments, name, comment, required);
        this.selected = new boolean[keys.length];
        this.defaultSelected = (boolean[])this.selected.clone();
        this.setValue(new String[]{keys[0]});
    }

    public MultiSelectionCollectionParameter(ParameterSet[] values, String name, String comment, boolean required) {
        super(values, name, comment, required);
        this.selected = new boolean[values.length];
        this.defaultSelected = (boolean[])this.selected.clone();
        try {
            this.setValue(new String[]{values[0].getInstanceName()});
        }
        catch (SimpleParameter.IllegalValueException doesnothappen) {
            doesnothappen.printStackTrace();
        }
    }

    public MultiSelectionCollectionParameter(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    protected MultiSelectionCollectionParameter(ParameterSet options, boolean[] selected, boolean[] defaultSelected, boolean userSelected, String name, String comment, boolean required, DataType datatype, String errorMessage, int current, boolean makeRanged) throws Exception {
        super(options, 0, 0, userSelected, name, comment, required, datatype, errorMessage, false);
        this.selected = (boolean[])selected.clone();
        this.defaultSelected = (boolean[])defaultSelected.clone();
        this.current = current;
        this.ranged = makeRanged;
        if (this.ranged) {
            this.parameters.makeRanged();
        }
    }

    public MultiSelectionCollectionParameter clone() throws CloneNotSupportedException {
        MultiSelectionCollectionParameter clone = (MultiSelectionCollectionParameter)super.clone();
        clone.defaultSelected = (boolean[])this.defaultSelected.clone();
        clone.selected = (boolean[])this.selected.clone();
        return clone;
    }

    public boolean setSelected(String key, boolean selected) {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.parameters.getParameterAt(i).getName().equals(key)) continue;
            this.selected[i] = selected;
            return true;
        }
        return false;
    }

    public boolean isSelected(String key) {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.parameters.getParameterAt(i).getName().equals(key)) continue;
            return this.selected[i];
        }
        return false;
    }

    public Object getValueFor(String key) {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.parameters.getParameterAt(i).getName().equals(key)) continue;
            if (this.selected[i]) {
                return this.parameters.getParameterAt(i).getValue();
            }
            return null;
        }
        return null;
    }

    public boolean checkValue(Object value) {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        if (value instanceof String[]) {
            String[] tmp = value;
            if (tmp.length == 0 && this.isRequired()) {
                this.errorMessage = "At least one value must be selected!";
                return false;
            }
            for (int i = 0; i < tmp.length; ++i) {
                if (super.checkValue(tmp[i])) continue;
                return false;
            }
            this.errorMessage = null;
            return true;
        }
        this.errorMessage = "Value not of the correct type";
        return false;
    }

    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (value instanceof String) {
            value = new String[]{(String)value};
        }
        if (this.checkValue(value)) {
            this.selected = new boolean[this.selected.length];
            this.current = -1;
            String[] tmp = value;
            for (int i = 0; i < tmp.length; ++i) {
                for (int j = 0; j < this.parameters.getNumberOfParameters(); ++j) {
                    if (!this.parameters.getParameterAt(j).getName().equals(tmp[i])) continue;
                    this.selected[j] = true;
                    if (this.current != -1 && j >= this.current) continue;
                    this.current = j;
                }
            }
            this.userSelected = true;
        }
    }

    public int getSelected() {
        return this.current;
    }

    public boolean setSelected(int idx, boolean selected) {
        if (idx < this.selected.length) {
            this.selected[idx] = selected;
            return true;
        }
        return false;
    }

    public boolean isSelected(int idx) {
        return idx < this.selected.length && this.selected[idx];
    }

    public Object getValueFor(int idx) {
        if (idx < this.selected.length && this.selected[idx]) {
            return this.parameters.getParameterAt(idx).getValue();
        }
        return null;
    }

    public Object[] getValues() {
        int count = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++count;
        }
        Object[] values = new Object[count];
        count = 0;
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.selected[i]) continue;
            values[count++] = this.parameters.getParameterAt(i).getValue();
        }
        return values;
    }

    public Object getValue() {
        if (this.current > -1) {
            return this.parameters.getParameterAt(this.current).getValue();
        }
        return null;
    }

    public boolean hasDefaultOrIsSet() {
        int numSelected = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++numSelected;
            if (this.parameters.getParameterAt(i).hasDefaultOrIsSet()) continue;
            System.out.println("parameter " + this.parameters.getParameterAt(i).getName() + " not set!!");
            return false;
        }
        return numSelected >= true || !this.isRequired();
    }

    public boolean isSet() {
        return this.userSelected;
    }

    public boolean isAtomic() {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!(this.parameters.getParameterAt(i).getValue() instanceof ParameterSet)) continue;
            return false;
        }
        return true;
    }

    public void simplify() {
        for (int i = 0; i < this.parameters.getNumberOfParameters(); ++i) {
            if (!this.selected[i] && this.parameters.getParameterAt(i).getValue() instanceof ParameterSet) {
                this.parameters.getParameterAt(i).reset();
                continue;
            }
            this.parameters.getParameterAt(i).simplify();
        }
    }

    public void reset() {
        this.selected = (boolean[])this.defaultSelected.clone();
        this.simplify();
    }

    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        this.setValue(defaultValue);
        this.defaultSelected = (boolean[])this.selected.clone();
        this.userSelected = false;
    }

    public StringBuffer toXML() {
        StringBuffer sup = super.toXML();
        XMLParser.addTags(sup, "superParameter");
        XMLParser.appendBooleanArrayWithTags(sup, this.selected, "selected");
        XMLParser.appendBooleanArrayWithTags(sup, this.defaultSelected, "defaultSelected");
        XMLParser.appendIntWithTags(sup, this.current, "current");
        XMLParser.addTags(sup, "multiSelectionCollectionParameter");
        return sup;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "multiSelectionCollectionParameter");
        super.fromXML(XMLParser.extractForTag(representation, "superParameter"));
        this.selected = XMLParser.extractBooleanArrayForTag(representation, "selected");
        this.defaultSelected = XMLParser.extractBooleanArrayForTag(representation, "defaultSelected");
        this.current = XMLParser.extractIntForTag(representation, "current");
    }

    public boolean next() throws ParameterException {
        int next = -1;
        for (int i = this.current + 1; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            next = i;
            break;
        }
        if (next != -1) {
            this.current = next;
            return true;
        }
        return false;
    }

    public void resetToFirst() {
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            this.current = i;
            break;
        }
    }

    public int getNumberOfValues() {
        int count = 0;
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++count;
        }
        return count;
    }

    public int getNumberOfNexts(int afterIdx) {
        int count = 0;
        for (int i = afterIdx + 1; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            ++count;
        }
        return count;
    }

    public String valuesToString() {
        StringBuffer tmp = new StringBuffer();
        for (int i = 0; i < this.selected.length; ++i) {
            if (!this.selected[i]) continue;
            tmp.append(this.parameters.getParameterAt(i).getName() + ", ");
        }
        tmp.delete(tmp.length() - 2, tmp.length());
        return "[" + tmp.toString() + "]";
    }

    public boolean isRanged() {
        return this.getNumberOfValues() > 1;
    }
}

