/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.AlphabetContainerParameterSet;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.Rangeable;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;

public abstract class InstanceParameterSet
extends ParameterSet {
    protected Parameter alphabet;
    protected Parameter length;
    private boolean variableLength;

    public static int getIndex(String[] names, Object[] values, Comparable current, boolean hasAlternative) throws IllegalArgumentException {
        int i = 0;
        int l = values.length;
        if (hasAlternative) {
            --l;
        }
        while (i < l && !current.equals(values[i])) {
            ++i;
        }
        if (i == values.length) {
            throw new IllegalArgumentException("Could not find a matching constant.");
        }
        return i;
    }

    public InstanceParameterSet(Class instanceClass, boolean discrete, boolean simple) {
        this(instanceClass, discrete, simple, false);
    }

    public InstanceParameterSet(Class instanceClass, boolean discrete, boolean simple, boolean variableLength) {
        super(instanceClass);
        this.variableLength = variableLength;
        try {
            this.alphabet = new ParameterSetContainer("Alphabet", "The alphabet the model works on", new AlphabetContainerParameterSet(discrete, simple));
            this.length = variableLength ? new SimpleParameter(DataType.INT, "Length", "The length of sequences the model can work on", true, new NumberValidator<Integer>(0, 0), 0) : new SimpleParameter(DataType.INT, "Length", "The length of sequences the model can work on", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE));
        }
        catch (ParameterException doesNotHappen) {
            // empty catch block
        }
        try {
            this.loadParameters();
        }
        catch (Exception e) {
            UnsupportedOperationException u = new UnsupportedOperationException(e.getMessage());
            u.setStackTrace(e.getStackTrace());
            throw u;
        }
    }

    public InstanceParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public InstanceParameterSet(Class instanceClass, AlphabetContainer alphabet, int length, boolean variableLength) throws Exception {
        this(instanceClass, alphabet.isDiscrete(), alphabet.isSimple(), variableLength);
        this.length.setValue(length);
        this.alphabet.setValue(alphabet.getCurrentParameterSet());
    }

    public InstanceParameterSet(Class instanceClass, AlphabetContainer alphabet) throws Exception {
        this(instanceClass, alphabet, 0, true);
    }

    public boolean hasDefaultOrIsSet() {
        boolean erg;
        boolean bl = erg = super.hasDefaultOrIsSet() && this.alphabet.hasDefaultOrIsSet() && this.length.hasDefaultOrIsSet();
        if (erg) {
            int l = 0;
            if (this.alphabet != null) {
                l = ((AlphabetContainerParameterSet)this.alphabet.getValue()).getPossibleLength();
            }
            if (!(erg &= l == 0 || (Integer)this.length.getValue() == l)) {
                this.errorMessage = "The length of the alphabet and the length of the model must match!";
            }
        }
        return erg;
    }

    public void reset() {
        super.reset();
        this.length.reset();
        this.alphabet.reset();
    }

    public AlphabetContainer getAlphabet() {
        try {
            AlphabetContainer cont = new AlphabetContainer((AlphabetContainerParameterSet)this.alphabet.getValue());
            return cont;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int getLength() throws IllegalArgumentException {
        int l = (Integer)this.length.getValue();
        if (this.variableLength && l != 0) {
            throw new IllegalArgumentException("The model can handle sequences of variable length, but length is defined as " + l);
        }
        return l;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "modelInstanceParameterSet");
        super.fromXML(XMLParser.extractForTag(representation, "superParameters"));
        String temp = null;
        try {
            temp = representation.toString();
            this.variableLength = XMLParser.extractBooleanForTag(representation, "variableLength");
            StringBuffer alphStringB = XMLParser.extractForTag(representation, "alphabet");
            this.alphabet = alphStringB == null ? null : new ParameterSetContainer(alphStringB);
            this.length = new SimpleParameter(XMLParser.extractForTag(representation, "length"));
        }
        catch (NonParsableException e) {
            e.printStackTrace();
            System.out.println("++++++++++++++++++++++++++++++++++++++++++");
            System.out.println("++++++++++++++++++++++++++++++++++++++++++");
            System.out.println(temp);
            System.out.println("++++++++++++++++++++++++++++++++++++++++++");
            throw e;
        }
    }

    public int getNumberOfParameters() {
        if (this.variableLength) {
            return super.getNumberOfParameters() + 1;
        }
        return super.getNumberOfParameters() + 2;
    }

    protected void replaceParametersWithRangedInstance() throws Exception {
        if (this.alphabet instanceof Rangeable && ((Rangeable)((Object)this.alphabet)).isRangeable()) {
            this.alphabet = ((Rangeable)((Object)this.alphabet)).getRangedInstance();
        }
        if (this.length instanceof Rangeable && ((Rangeable)((Object)this.length)).isRangeable()) {
            this.length = ((Rangeable)((Object)this.length)).getRangedInstance();
        }
        super.replaceParametersWithRangedInstance();
    }

    public Parameter getParameterAt(int i) {
        if (i < super.getNumberOfParameters()) {
            return super.getParameterAt(i);
        }
        if (i == super.getNumberOfParameters()) {
            return this.alphabet;
        }
        if (!this.variableLength) {
            return this.length;
        }
        throw new IndexOutOfBoundsException();
    }

    public StringBuffer toXML() {
        String superPars = super.toXML().toString();
        StringBuffer buf = new StringBuffer();
        XMLParser.appendStringWithTags(buf, superPars, "superParameters");
        XMLParser.appendBooleanWithTags(buf, this.variableLength, "variableLength");
        if (this.alphabet != null) {
            XMLParser.appendStringWithTags(buf, this.alphabet.toXML().toString(), "alphabet");
        }
        XMLParser.appendStringWithTags(buf, this.length.toXML().toString(), "length");
        XMLParser.addTags(buf, "modelInstanceParameterSet");
        return buf;
    }

    public boolean equals(Object o) {
        if (o instanceof InstanceParameterSet) {
            boolean erg;
            InstanceParameterSet comp = (InstanceParameterSet)o;
            int i = 0;
            for (erg = this.alternativeInstanceClass.equals(comp.alternativeInstanceClass) && this.getLength() == comp.getLength() && this.parameters.size() == comp.parameters.size() && this.getAlphabet().checkConsistency(comp.getAlphabet()) ? true : false; i < this.parameters.size() && erg; erg &= ((Parameter)this.parameters.get(i)).equals(comp.parameters.get(i++))) {
            }
            return erg;
        }
        return false;
    }

    public InstanceParameterSet clone() throws CloneNotSupportedException {
        InstanceParameterSet res = (InstanceParameterSet)super.clone();
        res.alphabet = this.alphabet.clone();
        res.length = this.length.clone();
        return res;
    }
}

