/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous.parameters;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.io.XMLParser;
import de.jstacs.models.discrete.inhomogeneous.FSDAGModel;
import de.jstacs.models.discrete.inhomogeneous.InhomogeneousDGM;
import de.jstacs.models.discrete.inhomogeneous.parameters.IDGMParameterSet;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FSDAGMParameterSet
extends IDGMParameterSet {
    public FSDAGMParameterSet(StringBuffer s) throws NonParsableException {
        super(s);
    }

    public FSDAGMParameterSet(Class<? extends FSDAGModel> clazz) {
        super(clazz);
    }

    public FSDAGMParameterSet(Class<? extends FSDAGModel> clazz, AlphabetContainer alphabet, int length, double ess, String description, String graph) throws Exception {
        super((Class<? extends InhomogeneousDGM>)clazz, alphabet, length, ess, description);
        ((Parameter)this.parameters.get(2)).setValue(graph);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new SimpleParameter(DataType.STRING, "graph structure", "the graph structure for the model (has to be acyclic)&lt;br&gt;The graph has to be given in a semi-XML-format, i.e. if 1, 2 and 5 are the parents from node 0 enter&lt;br&gt;&lt;parents node=0&gt;1,2,5&lt;/parents&gt;&lt;br&gt;the root nodes do not have to be insert explicitly", false));
    }

    @Override
    public String getInstanceComment() {
        return "holds the parameters for a fixed structure directed acyclic graphical model";
    }

    public static String encode(int[][] graph) {
        StringBuffer encoded = new StringBuffer(1000);
        for (int i = 0; i < graph.length; ++i) {
            if (graph[i] == null || graph[i].length <= 0) continue;
            StringBuffer help = new StringBuffer(100);
            help.append(graph[i][0]);
            for (int j = 1; j < graph[i].length; ++j) {
                help.append("," + graph[i][j]);
            }
            XMLParser.addTags(help, "parents node=" + i, "parents");
            encoded.append(help);
        }
        return encoded.toString();
    }
}

