/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.assessment;

import de.jstacs.WrongAlphabetException;
import de.jstacs.classifier.AbstractClassifier;
import de.jstacs.classifier.ClassDimensionException;
import de.jstacs.classifier.MeasureParameters;
import de.jstacs.classifier.assessment.ClassifierAssessment;
import de.jstacs.classifier.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.classifier.assessment.KFoldCVAssessParameterSet;
import de.jstacs.data.EmptySampleException;
import de.jstacs.data.Sample;
import de.jstacs.models.Model;
import de.jstacs.utils.ProgressUpdater;
import java.util.Arrays;

public class KFoldCrossValidation
extends ClassifierAssessment {
    protected KFoldCrossValidation(AbstractClassifier[] aCs, Model[][] aMs, boolean buildClassifiersByCrossProduct, boolean checkAlphabetConsistencyAndLength) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, aMs, buildClassifiersByCrossProduct, checkAlphabetConsistencyAndLength);
    }

    public KFoldCrossValidation(AbstractClassifier ... aCs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs);
    }

    public KFoldCrossValidation(boolean buildClassifiersByCrossProduct, Model[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(buildClassifiersByCrossProduct, aMs);
    }

    public KFoldCrossValidation(AbstractClassifier[] aCs, boolean buildClassifiersByCrossProduct, Model[] ... aMs) throws IllegalArgumentException, WrongAlphabetException, CloneNotSupportedException, ClassDimensionException {
        super(aCs, buildClassifiersByCrossProduct, aMs);
    }

    protected boolean evaluateClassifier(MeasureParameters mp, ClassifierAssessmentAssessParameterSet assessPS, Sample[] s, ProgressUpdater pU) throws IllegalArgumentException, Exception {
        KFoldCVAssessParameterSet tempAssessPS = null;
        try {
            tempAssessPS = (KFoldCVAssessParameterSet)assessPS;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Given AssessParameterSet is not of type KFoldCVAssessParameterSet.");
        }
        Sample.PartitionMethod splitMethod = tempAssessPS.getDataSplitMethod();
        int subSeqL = tempAssessPS.getElementLength();
        boolean exceptionIfMPNotComputable = tempAssessPS.getExceptionIfMPNotComputable();
        int k = tempAssessPS.getK();
        boolean[] tempBool = new boolean[k];
        Arrays.fill(tempBool, true);
        Sample[][] sInParts = new Sample[s.length][];
        try {
            int i = 0;
            while (i < sInParts.length) {
                sInParts[i] = s[i++].partition(k, splitMethod);
            }
        }
        catch (EmptySampleException e) {
            throw new IllegalArgumentException("Given Sample s seems to contain to few elements for a " + k + "-fold crossvalidation since at least one empty subset occured " + "during splitting given data into " + k + " non-overlapping parts.");
        }
        Sample[][] sTrainTestClassWise = new Sample[2][s.length];
        pU.setMax(k);
        for (int i = 0; i < k; ++i) {
            tempBool[i] = false;
            for (int j = 0; j < s.length; ++j) {
                sTrainTestClassWise[0][j] = Sample.union(sInParts[j], tempBool);
                sTrainTestClassWise[1][j] = new Sample(sInParts[j][i], subSeqL);
            }
            tempBool[i] = true;
            this.train(sTrainTestClassWise[0]);
            this.test(mp, exceptionIfMPNotComputable, sTrainTestClassWise[1]);
            pU.setValue(i + 1);
        }
        return true;
    }
}

