/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier;

import de.jstacs.parameters.ParameterException;
import de.jstacs.parameters.RangeParameter;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoreBasedPerformanceMeasureDefinitions {
    protected static double[][] getPartialROC(double[] scoresClass0, double[] scoresClass1, RangeParameter specs) throws ParameterException {
        int i = 0;
        int fn = 0;
        int n = specs.getNumberOfValues();
        double[][] val = new double[3][n];
        specs.resetToFirst();
        for (i = 0; i < n; ++i) {
            val[0][i] = (Double)specs.getValue();
            specs.next();
        }
        Arrays.sort(val[0]);
        for (i = 0; i < n; ++i) {
            val[2][i] = scoresClass1[(int)Math.ceil(val[0][i] * (double)(scoresClass1.length - 1))];
            while (fn < scoresClass0.length && scoresClass0[fn] <= val[2][i]) {
                ++fn;
            }
            val[1][i] = (double)(scoresClass0.length - fn) / (double)scoresClass0.length;
        }
        return val;
    }

    protected static double getAUC_PR(double[] scoresClass0, double[] scoresClass1, ArrayList<double[]> list) {
        boolean unique;
        int j;
        int i_old = 0;
        int j_old = 0;
        int i = 0;
        int d = scoresClass1.length;
        int m = scoresClass0.length;
        double erg = 0.0;
        double help1 = 0.0;
        double help2 = 0.0;
        for (j = 0; j < d && scoresClass0[i] > scoresClass1[j]; ++j) {
        }
        double[] p = new double[]{(double)(m - i) / (double)m, (double)(m - i) / (double)(m - i + d - j)};
        if (list != null) {
            list.add((double[])p.clone());
        }
        boolean fromMotif = false;
        if (j < d && scoresClass0[i] == scoresClass1[j]) {
            unique = false;
        } else {
            unique = true;
            fromMotif = true;
        }
        while (i < m && j < d) {
            i_old = i;
            j_old = j;
            if (unique) {
                if (fromMotif) {
                    while (i < m && scoresClass1[j] > scoresClass0[i]) {
                        ++i;
                    }
                } else {
                    while (j < d && scoresClass0[i] > scoresClass1[j]) {
                        ++j;
                    }
                }
            } else {
                while (i + 1 < m && scoresClass0[i] == scoresClass0[i + 1]) {
                    ++i;
                }
                while (j + 1 < d && scoresClass1[j] == scoresClass1[j + 1]) {
                    ++j;
                }
                ++i;
                ++j;
            }
            if (i == i_old) {
                p[1] = (double)(m - i) / (double)(m - i + d - j);
                if (list != null) {
                    list.add((double[])p.clone());
                }
            } else if (i < m || j < d) {
                double propTerm = (double)(j - j_old) / (double)(i - i_old);
                ++i_old;
                double helpJ = (double)j_old + propTerm;
                while (i_old <= i) {
                    help1 = (double)(m - i_old) / (double)m;
                    help2 = (double)(m - i_old) / ((double)(m - i_old + d) - helpJ);
                    helpJ += propTerm;
                    erg += (p[1] + help2) / 2.0 * (p[0] - help1);
                    p[0] = help1;
                    p[1] = help2;
                    if (list != null) {
                        list.add((double[])p.clone());
                    }
                    ++i_old;
                }
            } else {
                erg += p[1] * p[0];
                p[0] = 0.0;
                if (list != null) {
                    list.add((double[])p.clone());
                }
            }
            if (i >= m || j >= d) continue;
            if (scoresClass0[i] == scoresClass1[j]) {
                unique = false;
                continue;
            }
            unique = true;
            if (scoresClass0[i] < scoresClass1[j]) {
                fromMotif = true;
                continue;
            }
            fromMotif = false;
        }
        if (i < m) {
            help1 = 0.0;
            erg += p[1] * (p[0] - help1);
            p[0] = help1;
            if (list != null) {
                list.add((double[])p.clone());
            }
        }
        return erg;
    }

    protected static double getAUC_ROC(double[] scoresClass0, double[] scoresClass1, ArrayList<double[]> list) {
        boolean unique;
        int i = 0;
        int j = 0;
        int d = scoresClass1.length;
        int m = scoresClass0.length;
        double erg = 0.0;
        double[] p = new double[]{1.0, 1.0};
        if (list != null) {
            list.add((double[])p.clone());
        }
        boolean fromMotif = false;
        if (scoresClass0[i] == scoresClass1[j]) {
            unique = false;
        } else {
            unique = true;
            fromMotif = scoresClass0[i] < scoresClass1[j];
        }
        while (i < m && j < d) {
            if (unique) {
                if (fromMotif) {
                    while (i < m && scoresClass0[i] < scoresClass1[j]) {
                        ++i;
                    }
                } else {
                    while (j < d && scoresClass0[i] > scoresClass1[j]) {
                        ++j;
                    }
                }
            } else {
                while (i + 1 < m && scoresClass0[i] == scoresClass0[i + 1]) {
                    ++i;
                }
                while (j + 1 < d && scoresClass1[j] == scoresClass1[j + 1]) {
                    ++j;
                }
                ++i;
                ++j;
            }
            double help1 = (double)(d - j) / (double)d;
            double help2 = (double)(m - i) / (double)m;
            erg += (p[1] + help2) / 2.0 * (p[0] - help1);
            p[0] = help1;
            p[1] = help2;
            if (list != null) {
                list.add((double[])p.clone());
            }
            if (i >= m || j >= d) continue;
            if (scoresClass0[i] == scoresClass1[j]) {
                unique = false;
                continue;
            }
            unique = true;
            if (scoresClass0[i] < scoresClass1[j]) {
                fromMotif = true;
                continue;
            }
            fromMotif = false;
        }
        if (list != null) {
            list.add(new double[]{0.0, 0.0});
        }
        return erg;
    }

    private static double getCorrelationCoefficient(double tp, double fp, double fn, double tn) {
        return (tp * tn - fn * fp) / Math.sqrt((tp + fn) * (tn + fp) * (tp + fp) * (tn + fn));
    }

    protected static ThresholdMeasurePair getFPRForSensitivity(double[] scoresClass0, double[] scoresClass1, double sensitivity) throws IllegalArgumentException {
        int i;
        if (!(0.0 <= sensitivity) || !(sensitivity <= 1.0)) {
            throw new IllegalArgumentException("The value of percentage has to be in [0,1].");
        }
        int d = scoresClass1.length;
        double threshold = scoresClass0[(int)Math.ceil((1.0 - sensitivity) * (double)(scoresClass0.length - 1))];
        for (i = d - 1; i >= 0 && scoresClass1[i] >= threshold; --i) {
        }
        return new ThresholdMeasurePair(threshold, (double)(d - 1 - i) / (double)d);
    }

    protected static ThresholdMeasurePair getPPVForSensitivity(double[] scoresClass0, double[] scoresClass1, double sensitivity) throws IllegalArgumentException {
        int j;
        if (!(0.0 <= sensitivity) || !(sensitivity <= 1.0)) {
            throw new IllegalArgumentException("The value of percentage has to be in [0,1].");
        }
        int d = scoresClass1.length;
        int i = d - 1;
        double threshold = scoresClass0[j];
        for (j = (int)Math.ceil((1.0 - sensitivity) * (double)(scoresClass0.length - 1)); j >= 0 && scoresClass1[j] == threshold; --j) {
        }
        j = scoresClass0.length - 1 - j;
        while (i >= 0 && scoresClass1[i] >= threshold) {
            --i;
        }
        i = d - 1 - i;
        return new ThresholdMeasurePair(threshold, (double)j / (double)(i + j));
    }

    protected static ThresholdMeasurePair getMaxOfCC(double[] scoresClass0, double[] scoresClass1) throws Exception {
        int i;
        int j;
        int d = scoresClass1.length;
        int m = scoresClass0.length;
        double[] current = new double[2];
        double[] erg = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        if (scoresClass0[0] == scoresClass1[0]) {
            for (j = 1; j < d && scoresClass1[j - 1] == scoresClass1[j]; ++j) {
            }
            while (i < m && scoresClass0[i - 1] == scoresClass0[i]) {
                ++i;
            }
            if (i != m && j != d) {
                current[0] = Math.min(scoresClass1[j], scoresClass0[i]);
            } else {
                if (i == m && j == d) {
                    throw new Exception("All likelihood-ratios had the same values for both samples.");
                }
                current[0] = i == m ? scoresClass1[j] : scoresClass0[i];
            }
        } else if (scoresClass0[0] < scoresClass1[0]) {
            for (i = 1; i < m && scoresClass0[i - 1] == scoresClass0[i]; ++i) {
            }
            j = 0;
            current[0] = i == m ? scoresClass1[j] : (scoresClass0[i] <= scoresClass1[j] ? scoresClass0[i] : scoresClass1[j]);
        } else {
            while (j < d && scoresClass1[j - 1] == scoresClass1[j]) {
                ++j;
            }
            i = 0;
            current[0] = j == d ? scoresClass0[i] : (scoresClass1[j] <= scoresClass0[i] ? scoresClass1[j] : scoresClass0[i]);
        }
        while (i < m || j < d) {
            current[1] = ScoreBasedPerformanceMeasureDefinitions.getCorrelationCoefficient(m - i, d - j, i, j);
            if (current[1] > erg[1]) {
                erg[0] = current[0];
                erg[1] = current[1];
            }
            while (j < d && scoresClass1[j] == current[0]) {
                ++j;
            }
            while (i < m && scoresClass0[i] == current[0]) {
                ++i;
            }
            if (i < m && j < d) {
                if (scoresClass0[i] <= scoresClass1[j]) {
                    current[0] = scoresClass0[i];
                    continue;
                }
                current[0] = scoresClass1[j];
                continue;
            }
            if (i < m) {
                current[0] = scoresClass0[i];
                continue;
            }
            if (j >= d) continue;
            current[0] = scoresClass1[j];
        }
        return new ThresholdMeasurePair(erg[0], erg[1]);
    }

    protected static ThresholdMeasurePair getSensitivityForSpecificity(double[] scoresClass0, double[] scoresClass1, double specificity) throws IllegalArgumentException {
        int i;
        if (!(0.0 < specificity) || !(specificity < 1.0)) {
            throw new IllegalArgumentException("The value of specificity has to be in (0,1).");
        }
        int m = scoresClass0.length;
        double threshold = scoresClass1[(int)Math.ceil(specificity * (double)(scoresClass1.length - 1))];
        for (i = 0; i < m && scoresClass0[i] <= threshold; ++i) {
        }
        return new ThresholdMeasurePair(threshold, (double)(m - i) / (double)m);
    }

    protected static double getClassificationRateFor2Classes(double[] scoresClass0, double[] scoresClass1) {
        int j;
        int i;
        int m = scoresClass0.length;
        for (i = 0; i < m && scoresClass0[i] < 0.0; ++i) {
        }
        int d = scoresClass1.length;
        for (j = d - 1; j >= 0 && scoresClass1[j] >= 0.0; --j) {
        }
        return (double)(m - i + j + 1) / (double)(m + d);
    }

    public static class ThresholdMeasurePair {
        private double threshold;
        private double measure;

        public ThresholdMeasurePair(double threshold, double measure) {
            this.threshold = threshold;
            this.measure = measure;
        }

        public double getThreshold() {
            return this.threshold;
        }

        public double getMeasure() {
            return this.measure;
        }
    }
}

