/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.classifier.AbstractScoreBasedClassifier;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.util.Arrays;
import java.util.HashSet;

public class MappingClassifier
extends AbstractScoreBasedClassifier {
    private AbstractScoreBasedClassifier classifier;
    private int[][] classMapping;

    private static int getNum(int[] mapping) {
        HashSet<Integer> hash = new HashSet<Integer>();
        for (int i = 0; i < mapping.length; ++i) {
            if (hash.contains(mapping[i])) continue;
            hash.add(mapping[i]);
        }
        return hash.size();
    }

    public MappingClassifier(AbstractScoreBasedClassifier classifier, int[] mapping) throws CloneNotSupportedException {
        super(classifier.getAlphabetContainer(), classifier.getLength(), MappingClassifier.getNum(mapping));
        int i;
        if (mapping.length != classifier.getNumberOfClasses()) {
            throw new IllegalArgumentException("The length of the mapping is not correct.");
        }
        IntList[] il = new IntList[this.getNumberOfClasses()];
        for (i = 0; i < il.length; ++i) {
            il[i] = new IntList();
        }
        for (i = 0; i < mapping.length; ++i) {
            il[mapping[i]].add(i);
        }
        this.classMapping = new int[il.length][];
        for (i = 0; i < il.length; ++i) {
            if (il[i].length() == 0) {
                throw new IllegalArgumentException("Mapping to class " + i + " is empty");
            }
            this.classMapping[i] = il[i].toArray();
        }
        this.classifier = classifier.clone();
    }

    public MappingClassifier(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        super.extractFurtherClassifierInfosFromXML(xml);
        this.classifier = (AbstractScoreBasedClassifier)XMLParser.extractStorableForTag(xml, "classifier");
        this.classMapping = XMLParser.extractInt2ArrayForTag(xml, "mapping");
    }

    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendStorableWithTags(xml, this.classifier, "classifier");
        XMLParser.appendInt2ArrayWithTags(xml, this.classMapping, "mapping");
        return xml;
    }

    protected double getScore(Sequence seq, int i, boolean check) throws IllegalArgumentException, NotTrainedException, Exception {
        double res = this.classifier.getScore(seq, this.classMapping[i][0], true);
        for (int idx = 1; idx < this.classMapping[i].length; ++idx) {
            res = Normalisation.getLogSum(res, this.classifier.getScore(seq, this.classMapping[i][1], false));
        }
        return res;
    }

    public CategoricalResult[] getClassifierAnnotation() {
        return this.classifier.getClassifierAnnotation();
    }

    public String getInstanceName() {
        return "MappingClassifier of " + this.classifier.getInstanceName();
    }

    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return this.classifier.getNumericalCharacteristics();
    }

    protected String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    public boolean isTrained() {
        return this.classifier.isTrained();
    }

    public void train(Sample[] s, double[][] weights) throws Exception {
        this.classifier.train(s, weights);
    }

    public Sample[] mapSample(Sample[] s) {
        boolean[] in = new boolean[this.classifier.getNumberOfClasses()];
        Sample[] mapped = new Sample[this.classMapping.length];
        try {
            for (int i = 0; i < mapped.length; ++i) {
                Arrays.fill(in, false);
                for (int j = 0; j < this.classMapping[i].length; ++j) {
                    in[this.classMapping[i][j]] = true;
                }
                mapped[i] = Sample.union(s, in);
            }
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
        return mapped;
    }
}

