/*
 * Decompiled with CFR 0.152.
 */
package org.biojavax.bio.phylo.io.phylip;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.symbol.Alignment;
import org.biojavax.bio.phylo.io.phylip.PHYLIPFileListener;

public class PHYLIPFileFormat {
    private static int MAX_NAME_LENGTH = 10;

    private PHYLIPFileFormat() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseFile(PHYLIPFileListener listener, File inputFile) throws IOException, ParseException {
        FileReader fr = new FileReader(inputFile);
        try {
            PHYLIPFileFormat.parseReader(listener, fr);
        }
        finally {
            fr.close();
        }
    }

    public static void parseInputStream(PHYLIPFileListener listener, InputStream inputStream) throws IOException, ParseException {
        PHYLIPFileFormat.parseReader(listener, new InputStreamReader(inputStream));
    }

    public static void parseReader(PHYLIPFileListener listener, Reader inputReader) throws IOException, ParseException {
        PHYLIPFileFormat.parse(listener, inputReader instanceof BufferedReader ? (BufferedReader)inputReader : new BufferedReader(inputReader));
    }

    public static void parse(PHYLIPFileListener listener, BufferedReader reader) throws IOException, ParseException {
        listener.startFile();
        ArrayList<String> sequenceNames = new ArrayList<String>();
        String headerline = reader.readLine();
        Pattern pattern = Pattern.compile("\\s*(\\d+)\\s+(\\d+)\\s*");
        Matcher matcher = pattern.matcher(headerline);
        if (!matcher.matches()) {
            throw new ParseException("Invalid header line.");
        }
        int sequenceCount = Integer.parseInt(matcher.group(1));
        listener.setSequenceCount(sequenceCount);
        int sitesCount = Integer.parseInt(matcher.group(2));
        listener.setSitesCount(sitesCount);
        int currentSequenceIndex = 0;
        boolean collectedAllNames = false;
        String line = reader.readLine();
        while (line != null) {
            if (line.length() == 0) continue;
            if (!collectedAllNames) {
                String name = line.substring(0, MAX_NAME_LENGTH).trim();
                sequenceNames.add(name);
                line = line.substring(MAX_NAME_LENGTH).replaceAll("\\s", "");
            }
            listener.setCurrentSequenceName((String)sequenceNames.get(currentSequenceIndex));
            listener.receiveSequence(line);
            if (sequenceNames.size() == sequenceCount) {
                collectedAllNames = true;
            }
            if (++currentSequenceIndex >= sequenceCount) {
                currentSequenceIndex = 0;
            }
            line = reader.readLine();
        }
        listener.endFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, Alignment alignment) throws IOException {
        FileWriter fw = new FileWriter(file);
        try {
            PHYLIPFileFormat.writeWriter(fw, alignment);
        }
        finally {
            fw.close();
        }
    }

    public static void writeStream(OutputStream os, Alignment alignment) throws IOException {
        OutputStreamWriter ow = new OutputStreamWriter(os);
        PHYLIPFileFormat.writeWriter(ow, alignment);
    }

    public static void writeWriter(Writer writer, Alignment alignment) throws IOException {
        String lineSep = System.getProperty("line.separator");
        writer.write("" + alignment.getLabels().size());
        writer.write("   ");
        writer.write("" + alignment.length() + lineSep);
        for (String label : alignment.getLabels()) {
            String sequence = alignment.symbolListForLabel(label).seqString();
            writer.write(PHYLIPFileFormat.formatSequenceLabel(label));
            writer.write(sequence);
            writer.write(lineSep);
        }
        writer.flush();
    }

    private static String formatSequenceLabel(String label) {
        if (label.length() > MAX_NAME_LENGTH) {
            return label.substring(0, MAX_NAME_LENGTH);
        }
        if (label.length() < MAX_NAME_LENGTH) {
            StringBuffer buffer = new StringBuffer(label);
            while (buffer.length() < MAX_NAME_LENGTH) {
                buffer.append(" ");
            }
            return buffer.toString();
        }
        return label;
    }
}

