/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.net.MalformedURLException;
import java.net.URL;
import org.biojava.bio.BioException;
import org.biojava.bio.BioRuntimeException;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.seq.db.WebSequenceDB;
import org.biojava.bio.seq.io.FastaFormat;
import org.biojava.bio.seq.io.GenbankFormat;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.symbol.Alphabet;

public class NCBISequenceDB
extends WebSequenceDB {
    private String server;
    private String CGI;
    private SequenceFormat format;
    private String dataBase;
    private Alphabet alpha;
    private String formatName;
    public static final String DB_NUCLEOTIDE = "nucleotide";
    public static final String DB_PROTEIN = "protein";

    public NCBISequenceDB() {
        this("http://www.ncbi.nlm.nih.gov/", "entrez/query.fcgi", DB_NUCLEOTIDE, new FastaFormat());
    }

    public NCBISequenceDB(String database, SequenceFormat format) {
        this("http://www.ncbi.nlm.nih.gov/", "entrez/query.fcgi", database, format);
    }

    public NCBISequenceDB(String server, String CGI, String database, SequenceFormat format) throws BioRuntimeException {
        this.server = server;
        this.CGI = CGI;
        try {
            this.setDatabase(database);
        }
        catch (BioException ex) {
            throw new BioRuntimeException("Database format must be one of {nucleotide, protein}");
        }
        try {
            this.setSequenceFormat(format);
        }
        catch (BioException ex) {
            throw new BioRuntimeException("SequenceFormat object must be one of {FastaFormat, GenbankFormat}");
        }
    }

    public String getDataBase() {
        return this.dataBase;
    }

    public void setDatabase(String dataBase) throws BioException {
        if (dataBase == DB_NUCLEOTIDE) {
            this.dataBase = DB_NUCLEOTIDE;
            this.alpha = DNATools.getDNA();
        } else if (dataBase == DB_PROTEIN) {
            this.dataBase = DB_PROTEIN;
            this.alpha = ProteinTools.getAlphabet();
        } else {
            throw new BioException("Database format must be one of {nucleotide, protein}");
        }
    }

    public SequenceFormat getSequenceFormat() {
        return this.format;
    }

    public void setSequenceFormat(SequenceFormat format) throws BioException {
        if (format instanceof FastaFormat) {
            this.format = format;
            this.formatName = "FASTA";
        } else if (format instanceof GenbankFormat) {
            this.format = format;
            this.formatName = this.alpha == DNATools.getDNA() ? "GenBank" : "GenPept";
        } else {
            throw new BioException("Only Genbank and FASTA formats currently supported");
        }
    }

    protected Alphabet getAlphabet() {
        return this.alpha;
    }

    protected URL getAddress(String uid) throws MalformedURLException {
        String query = "cmd=text&db=" + this.dataBase + "&uid=" + uid + "&dopt=" + this.formatName;
        return new URL(this.server + this.CGI + "?" + query);
    }

    public String getName() {
        return "NCBI-Genbank";
    }
}

