/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable;

import de.jstacs.NotTrainedException;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.AbstractTrainableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import java.text.NumberFormat;

public class VariableLengthWrapperTrainSM
extends AbstractTrainableStatisticalModel {
    private TrainableStatisticalModel m;

    public VariableLengthWrapperTrainSM(TrainableStatisticalModel m) throws CloneNotSupportedException {
        super(m.getAlphabetContainer(), m.getLength());
        this.m = m.clone();
    }

    public VariableLengthWrapperTrainSM(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    @Override
    public VariableLengthWrapperTrainSM clone() throws CloneNotSupportedException {
        VariableLengthWrapperTrainSM clone = (VariableLengthWrapperTrainSM)super.clone();
        clone.m = this.m.clone();
        return clone;
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer content = XMLParser.extractForTag(xml, this.getInstanceName());
        this.m = XMLParser.extractObjectForTags(content, "model", TrainableStatisticalModel.class);
        this.alphabets = this.m.getAlphabetContainer();
        this.length = this.m.getLength();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.m, "model");
        XMLParser.addTags(xml, this.getInstanceName());
        return xml;
    }

    @Override
    public String getInstanceName() {
        return this.m.getInstanceName();
    }

    @Override
    public double getLogPriorTerm() throws Exception {
        return this.m.getLogPriorTerm();
    }

    @Override
    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return this.m.getNumericalCharacteristics();
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws NotTrainedException, Exception {
        return this.m.getLogProbFor(sequence, startpos, endpos);
    }

    @Override
    public boolean isInitialized() {
        return this.m.isInitialized();
    }

    @Override
    public void train(DataSet data, double[] weights) throws Exception {
        DataSet.WeightedDataSetFactory wsf = new DataSet.WeightedDataSetFactory(DataSet.WeightedDataSetFactory.SortOperation.NO_SORT, data, weights, this.length);
        this.m.train(wsf.getDataSet(), wsf.getWeights());
    }

    @Override
    public String toString(NumberFormat nf) {
        return this.m.toString(nf);
    }
}

