/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable;

import de.jstacs.NotTrainedException;
import de.jstacs.Storable;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import de.jstacs.sequenceScores.statisticalModels.trainable.TrainableStatisticalModel;
import java.text.NumberFormat;
import java.util.Locale;

public abstract class AbstractTrainableStatisticalModel
implements Cloneable,
Storable,
TrainableStatisticalModel {
    protected int length;
    protected AlphabetContainer alphabets;

    public AbstractTrainableStatisticalModel(AlphabetContainer alphabets, int length) {
        this.length = length;
        this.alphabets = alphabets;
        if (alphabets.getPossibleLength() > 0 && alphabets.getPossibleLength() != length) {
            throw new IllegalArgumentException("The length and the alphabet container does not match.");
        }
    }

    public AbstractTrainableStatisticalModel(StringBuffer stringBuff) throws NonParsableException {
        this.alphabets = null;
        this.length = -1;
        this.fromXML(stringBuff);
        if (this.alphabets == null) {
            throw new NonParsableException("The alphabets were not set correctly.");
        }
        if (this.length < 0) {
            throw new NonParsableException("The length was not set correctly.");
        }
        if (this.alphabets.getPossibleLength() > 0 && this.alphabets.getPossibleLength() != this.length) {
            throw new IllegalArgumentException("The length and the alphabet container doesnot not match.");
        }
    }

    @Override
    public AbstractTrainableStatisticalModel clone() throws CloneNotSupportedException {
        return (AbstractTrainableStatisticalModel)super.clone();
    }

    @Override
    public void train(DataSet data) throws Exception {
        this.train(data, null);
    }

    @Override
    public double getLogProbFor(Sequence sequence) throws Exception {
        return this.getLogProbFor(sequence, 0, sequence.getLength() - 1);
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos) throws Exception {
        if (this.length == 0) {
            return this.getLogProbFor(sequence, startpos, sequence.getLength() - 1);
        }
        return this.getLogProbFor(sequence, startpos, startpos + this.length - 1);
    }

    protected void check(Sequence sequence, int startpos, int endpos) throws NotTrainedException, IllegalArgumentException {
        if (!this.isInitialized()) {
            throw new NotTrainedException();
        }
        if (!this.alphabets.checkConsistency(sequence.getAlphabetContainer().getSubContainer(startpos, endpos - startpos + 1))) {
            throw new IllegalArgumentException("This sequence is not possible with the given alphabet.");
        }
        if (startpos < 0) {
            throw new IllegalArgumentException("This startposition is impossible. Try: 0 <= startposition");
        }
        if (startpos > endpos || endpos >= sequence.getLength()) {
            throw new IllegalArgumentException("This endposition is impossible. Try: startposition <= endposition < sequence.length");
        }
        if (this.length != 0 && endpos - startpos + 1 != this.length) {
            throw new IllegalArgumentException("This sequence has not length " + this.length + ".");
        }
    }

    @Override
    public double getLogScoreFor(Sequence sequence) {
        return this.getLogScoreFor(sequence, 0);
    }

    @Override
    public double getLogScoreFor(Sequence sequence, int startpos) {
        try {
            return this.getLogProbFor(sequence, startpos);
        }
        catch (Exception e) {
            RuntimeException r = new RuntimeException();
            r.setStackTrace(e.getStackTrace());
            throw r;
        }
    }

    @Override
    public double getLogScoreFor(Sequence sequence, int startpos, int endpos) {
        try {
            return this.getLogProbFor(sequence, startpos, endpos);
        }
        catch (Exception e) {
            RuntimeException r = new RuntimeException();
            r.setStackTrace(e.getStackTrace());
            throw r;
        }
    }

    @Override
    public double[] getLogScoreFor(DataSet data) throws Exception {
        double[] res = new double[data.getNumberOfElements()];
        this.getLogScoreFor(data, res);
        return res;
    }

    @Override
    public void getLogScoreFor(DataSet data, double[] res) throws Exception {
        if (res.length != data.getNumberOfElements()) {
            throw new IllegalArgumentException("The array has wrong dimension.");
        }
        DataSet.ElementEnumerator ei = new DataSet.ElementEnumerator(data);
        int i = 0;
        while (i < res.length) {
            res[i] = this.getLogScoreFor(ei.nextElement());
            ++i;
        }
    }

    @Override
    public DataSet emitDataSet(int numberOfSequences, int ... seqLength) throws NotTrainedException, Exception {
        throw new Exception("Standard implementation of emitDataSet used for " + this.getInstanceName() + ". You have to overwrite this method to use it in a proper way.");
    }

    @Override
    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabets;
    }

    @Override
    public final int getLength() {
        return this.length;
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The maximal markov order for this model in undefined.");
    }

    @Override
    public ResultSet getCharacteristics() throws Exception {
        return new ResultSet(this.getNumericalCharacteristics().getResults(), {new StorableResult("model", "the xml representation of the model", this)});
    }

    protected abstract void fromXML(StringBuffer var1) throws NonParsableException;

    @Override
    public final String toString() {
        NumberFormat nf = NumberFormat.getInstance(Locale.US);
        nf.setMaximumFractionDigits(3);
        return this.toString(nf);
    }
}

