/*
 * Decompiled with CFR 0.152.
 */
package projects.dispom;

import de.jstacs.classifiers.utils.PValueComputation;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.utils.ComparableElement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Random;

public class PFMComparator {
    private static Random r = new Random();

    public static String matrixToString(double[][] matrix) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < matrix.length; ++i) {
            sb.append(matrix[i][0]);
            for (int j = 1; j < matrix[i].length; ++j) {
                sb.append('\t');
                sb.append(matrix[i][j]);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String getConsensus(AlphabetContainer con, double[][] pfm) {
        String c = "";
        for (int l = 0; l < pfm.length; ++l) {
            int m = 0;
            for (int p = 1; p < pfm[l].length; ++p) {
                if (!(pfm[l][m] < pfm[l][p])) continue;
                m = p;
            }
            c = c + con.getSymbol(l, m);
        }
        return c;
    }

    public static double[] getCounts(DataSet ... data) {
        double[] counts = new double[(int)data[0].getAlphabetContainer().getAlphabetLengthAt(0)];
        for (int d = 0; d < data.length; ++d) {
            for (int n = 0; n < data[d].getNumberOfElements(); ++n) {
                Sequence seq = data[d].getElementAt(n);
                for (int l = 0; l < seq.getLength(); ++l) {
                    int n2 = seq.discreteVal(l);
                    counts[n2] = counts[n2] + 1.0;
                }
            }
        }
        return counts;
    }

    public static void normalize(double[] counts) {
        int l;
        double sum = 0.0;
        for (l = 0; l < counts.length; ++l) {
            sum += counts[l];
        }
        l = 0;
        while (l < counts.length) {
            int n = l++;
            counts[n] = counts[n] / sum;
        }
    }

    public static double[][] getPFM(DataSet data) {
        if (data == null) {
            return null;
        }
        double[][] pfm = new double[data.getElementLength()][];
        AlphabetContainer con = data.getAlphabetContainer();
        for (int l = 0; l < pfm.length; ++l) {
            pfm[l] = new double[(int)con.getAlphabetLengthAt(l)];
        }
        for (int n = 0; n < data.getNumberOfElements(); ++n) {
            Sequence seq = data.getElementAt(n);
            for (int l = 0; l < pfm.length; ++l) {
                double[] dArray = pfm[l];
                int n2 = seq.discreteVal(l);
                dArray[n2] = dArray[n2] + 1.0;
            }
        }
        return pfm;
    }

    public static double[][] getPFM(DataSet data, double[] weights) {
        if (data == null) {
            return null;
        }
        double[][] pfm = new double[data.getElementLength()][];
        AlphabetContainer con = data.getAlphabetContainer();
        for (int l = 0; l < pfm.length; ++l) {
            pfm[l] = new double[(int)con.getAlphabetLengthAt(l)];
        }
        for (int n = 0; n < data.getNumberOfElements(); ++n) {
            Sequence seq = data.getElementAt(n);
            for (int l = 0; l < pfm.length; ++l) {
                double[] dArray = pfm[l];
                int n2 = seq.discreteVal(l);
                dArray[n2] = dArray[n2] + weights[n];
            }
        }
        return pfm;
    }

    public static double[][] getReverseComplement(ComplementableDiscreteAlphabet abc, double[][] pfm) {
        int length = pfm.length;
        int symbols = (int)abc.length();
        double[][] pfmRC = new double[length][symbols];
        for (int l = 0; l < length; ++l) {
            for (int a = 0; a < symbols; ++a) {
                pfmRC[l][a] = pfm[length - 1 - l][abc.getComplementaryCode(a)];
            }
        }
        return pfmRC;
    }

    public static ArrayList<AbstractMap.SimpleEntry<String, double[][]>> readPFMsFromEMBL(String fileName, int max) throws IOException {
        String line;
        ArrayList<AbstractMap.SimpleEntry<String, double[][]>> res = new ArrayList<AbstractMap.SimpleEntry<String, double[][]>>();
        ArrayList<double[]> pfm = new ArrayList<double[]>();
        double[][] tooSmall = new double[][]{};
        BufferedReader r = new BufferedReader(new FileReader(new File(fileName)));
        while (res.size() < max && (line = r.readLine()) != null) {
            if (!line.startsWith("AC")) continue;
            String annot = line.substring(line.indexOf(32)).trim();
            while (!(line = r.readLine()).startsWith("ID")) {
            }
            annot = annot + " (" + line.substring(line.indexOf(32)).trim() + ")";
            while (!(line = r.readLine()).startsWith("01")) {
            }
            pfm.clear();
            do {
                String[] split = line.split("[ ]+");
                double[] positionalFrequencies = new double[split.length - 2];
                for (int a = 0; a < positionalFrequencies.length; ++a) {
                    positionalFrequencies[a] = Double.parseDouble(split[1 + a]);
                }
                pfm.add(positionalFrequencies);
            } while (!(line = r.readLine()).startsWith("XX"));
            res.add(new AbstractMap.SimpleEntry<String, T[]>(annot, pfm.toArray((T[])tooSmall)));
            while (!(line = r.readLine()).startsWith("//")) {
            }
        }
        r.close();
        return res;
    }

    public static ComparableElement<String, Double>[] find(ComplementableDiscreteAlphabet abc, double[][] pfm, ArrayList<AbstractMap.SimpleEntry<String, double[][]>> knownPFMs, PFMDistance distance, int minOverlap, int allowMiniShift, boolean pValues, double threshold) {
        int i;
        ArrayList<ComparableElement<String, Double>> list = new ArrayList<ComparableElement<String, Double>>(10);
        double[][] pfmRC = PFMComparator.getReverseComplement(abc, pfm);
        int m = Math.min(minOverlap, pfm.length - allowMiniShift);
        int columns = 0;
        Hashtable<Integer, double[]> scores = new Hashtable<Integer, double[]>();
        if (pValues) {
            for (i = 0; i < knownPFMs.size(); ++i) {
                columns += knownPFMs.get(i).getValue().length;
            }
        }
        for (i = 0; i < knownPFMs.size(); ++i) {
            double[][] currentCand = knownPFMs.get(i).getValue();
            int myMinimalOverlap = Math.min(m, currentCand.length - allowMiniShift);
            double d = Math.min(distance.compare(pfm, currentCand, myMinimalOverlap), distance.compare(pfmRC, currentCand, myMinimalOverlap));
            if (pValues) {
                double[] values = (double[])scores.get(currentCand.length);
                if (values == null) {
                    values = new double[1000];
                    double[][] randomPFM = new double[currentCand.length][];
                    for (int n = 0; n < values.length; ++n) {
                        for (int l = 0; l < randomPFM.length; ++l) {
                            int len;
                            int c = r.nextInt(columns);
                            int idx = 0;
                            while ((len = knownPFMs.get(idx).getValue().length) <= c) {
                                c -= len;
                                ++idx;
                            }
                            randomPFM[l] = knownPFMs.get(idx).getValue()[c];
                        }
                        values[n] = Math.min(distance.compare(pfm, randomPFM, myMinimalOverlap), distance.compare(pfmRC, randomPFM, myMinimalOverlap));
                    }
                    Arrays.sort(values);
                    scores.put(currentCand.length, values);
                }
                d = PValueComputation.getPValue(values, d);
            }
            if (!(d <= threshold)) continue;
            list.add(new ComparableElement<String, Double>(knownPFMs.get(i).getKey(), d));
        }
        Object[] res = list.toArray(new ComparableElement[0]);
        Arrays.sort(res);
        return res;
    }

    public static class SymmetricKullbackLeiblerDivergence
    extends PFMDistance {
        private double ess;

        public SymmetricKullbackLeiblerDivergence(double ess) throws IllegalArgumentException {
            if (ess < 0.0) {
                throw new IllegalArgumentException("The ess has to be non-negative.");
            }
            this.ess = ess;
        }

        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                int a;
                double sum2;
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum1 = sum2 = this.ess;
                double pc = this.ess / (double)pfm1[l1].length;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                }
                for (a = 0; a < pfm1[l1].length; ++a) {
                    double p1_a = (pc + pfm1[l1][a]) / sum1;
                    double p2_a = (pc + pfm2[l2][a]) / sum2;
                    res += (p1_a - p2_a) * Math.log(p1_a / p2_a);
                }
                ++l1;
                ++l2;
                ++l;
            }
            return 1.0 / (2.0 * (double)l) * res;
        }
    }

    public static class OneMinusPearsonCorrelationCoefficient
    extends PFMDistance {
        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                int a;
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum2 = 0.0;
                double sum1 = 0.0;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                }
                double s2 = 0.0;
                double s1 = 0.0;
                double s = 0.0;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    double d1 = pfm1[l1][a] / sum1 - 0.25;
                    double d2 = pfm2[l2][a] / sum2 - 0.25;
                    s += d1 * d2;
                    s1 += d1 * d1;
                    s2 += d2 * d2;
                }
                res += s / Math.sqrt(s1 * s2);
                ++l1;
                ++l2;
                ++l;
            }
            return 1.0 - 1.0 / (double)l * res;
        }
    }

    public static class NormalizedEuclideanDistance
    extends PFMDistance {
        @Override
        protected double getDistance(double[][] pfm1, double[][] pfm2, int l1, int l2) {
            double res = 0.0;
            int l = 0;
            while (l1 < pfm1.length && l2 < pfm2.length) {
                int a;
                if (pfm1[l1].length != pfm2[l2].length) {
                    throw new IllegalArgumentException("The PFMs are not comparable at column " + l1 + " and " + l2 + ".");
                }
                double sum2 = 0.0;
                double sum1 = 0.0;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    sum1 += pfm1[l1][a];
                    sum2 += pfm2[l2][a];
                }
                double sum = 0.0;
                for (a = 0; a < pfm1[l1].length; ++a) {
                    double diff = pfm1[l1][a] / sum1 - pfm2[l2][a] / sum2;
                    sum += diff * diff;
                }
                res += Math.sqrt(sum);
                ++l1;
                ++l2;
                ++l;
            }
            return res / (Math.sqrt(2.0) * (double)l);
        }
    }

    public static abstract class PFMDistance {
        public final double getDistance(double[][] pfm1, double[][] pfm2, int offset) {
            if (offset >= 0) {
                return this.getDistance(pfm1, pfm2, offset, 0);
            }
            return this.getDistance(pfm1, pfm2, 0, -offset);
        }

        protected abstract double getDistance(double[][] var1, double[][] var2, int var3, int var4);

        public double compare(double[][] pfm1, double[][] pfm2, int minimalOverlap) {
            int l1 = pfm1.length;
            int l2 = pfm2.length;
            if (l1 < minimalOverlap || l2 < minimalOverlap) {
                throw new IllegalArgumentException("The PFM are too small to have a minimal overlap of " + minimalOverlap + ".");
            }
            double best = Double.POSITIVE_INFINITY;
            for (int offset = minimalOverlap - l2; offset <= l1 - minimalOverlap; ++offset) {
                double current = this.getDistance(pfm1, pfm2, offset);
                if (!(current < best)) continue;
                best = current;
            }
            return best;
        }
    }
}

