/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.motifDiscovery.history;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.history.History;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class RestrictedRepeatHistory
implements History {
    private int threshold;
    private int[] anz;
    private int[] last;
    private Hashtable<String, int[]> hash;
    private boolean allowShift;
    private boolean allowShrink;
    private boolean allowExpand;
    private boolean allowReverse;

    public RestrictedRepeatHistory() {
        this(true, true, true, true, 1);
    }

    public RestrictedRepeatHistory(boolean allowReverse) {
        this(true, true, true, allowReverse, 1);
    }

    public RestrictedRepeatHistory(int threshold) {
        this(true, true, true, true, threshold);
    }

    public RestrictedRepeatHistory(boolean allowShift, boolean allowShrink, boolean allowExpand) {
        this(allowShift, allowShrink, allowExpand, true, 1);
    }

    public RestrictedRepeatHistory(boolean allowShift, boolean allowShrink, boolean allowExpand, boolean allowReverse, int threshold) throws IllegalArgumentException {
        this.allowShift = allowShift;
        this.allowShrink = allowShrink;
        this.allowExpand = allowExpand;
        this.allowReverse = allowReverse;
        if (threshold < 1) {
            throw new IllegalArgumentException("The threshold has to be at least 1.");
        }
        this.threshold = threshold;
        this.hash = new Hashtable();
        this.last = new int[2];
        this.clear();
    }

    public RestrictedRepeatHistory(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getXMLTag());
        this.last = (int[])XMLParser.extractObjectForTags(xml, "last");
        this.anz = (int[])XMLParser.extractObjectForTags(xml, "anz");
        String[] opList = (String[])XMLParser.extractObjectForTags(xml, "opList");
        int[][] anzList = (int[][])XMLParser.extractObjectForTags(xml, "anzList");
        this.hash = new Hashtable();
        for (int i = 0; i < opList.length; ++i) {
            this.hash.put(opList[i], anzList[i]);
        }
        this.threshold = (Integer)XMLParser.extractObjectForTags(xml, "threshold");
        this.allowExpand = (Boolean)XMLParser.extractObjectForTags(xml, "allowExpand");
        this.allowShift = (Boolean)XMLParser.extractObjectForTags(xml, "allowShift");
        this.allowShrink = (Boolean)XMLParser.extractObjectForTags(xml, "allowShrink");
        this.allowReverse = (Boolean)XMLParser.extractObjectForTags(xml, "allowReverse");
    }

    private String getXMLTag() {
        return this.getClass().getSimpleName();
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.last, "last");
        XMLParser.appendObjectWithTags(xml, this.anz, "anz");
        Iterator<Map.Entry<String, int[]>> it = this.hash.entrySet().iterator();
        LinkedList<String> opList = new LinkedList<String>();
        LinkedList<int[]> anzList = new LinkedList<int[]>();
        while (it.hasNext()) {
            Map.Entry<String, int[]> e = it.next();
            opList.add(e.getKey());
            anzList.add(e.getValue());
        }
        XMLParser.appendObjectWithTags(xml, opList.toArray(new String[0]), "opList");
        XMLParser.appendObjectWithTags(xml, anzList.toArray((T[])new int[0][]), "anzList");
        XMLParser.appendObjectWithTags(xml, this.threshold, "threshold");
        XMLParser.appendObjectWithTags(xml, this.allowExpand, "allowExpand");
        XMLParser.appendObjectWithTags(xml, this.allowShift, "allowShift");
        XMLParser.appendObjectWithTags(xml, this.allowShrink, "allowShrink");
        XMLParser.appendObjectWithTags(xml, this.allowReverse, "allowReverse");
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    @Override
    public RestrictedRepeatHistory clone() throws CloneNotSupportedException {
        RestrictedRepeatHistory clone = (RestrictedRepeatHistory)super.clone();
        clone.anz = this.anz == null ? null : (int[])this.anz.clone();
        clone.hash = new Hashtable();
        for (Map.Entry<String, int[]> e : this.hash.entrySet()) {
            clone.hash.put(e.getKey(), (int[])e.getValue().clone());
        }
        clone.last = (int[])this.last.clone();
        return clone;
    }

    @Override
    public void clear() {
        this.hash.clear();
    }

    @Override
    public boolean operationAllowed(int ... op) {
        if (op.length != 2 || !this.allowReverse && op[0] == -this.last[0] && op[1] == -this.last[1]) {
            return false;
        }
        int sum = op[1] - op[0];
        if (!this.allowShift && sum == 0 || !this.allowShrink && sum < 0 || !this.allowExpand && sum > 0) {
            return false;
        }
        if (this.allowShrink && sum < 0) {
            return true;
        }
        this.anz = this.hash.get(Arrays.toString(op));
        return this.anz == null || this.anz[0] < this.threshold;
    }

    @Override
    public void operationPerfomed(int ... op) {
        String s = Arrays.toString(op);
        this.anz = this.hash.get(s);
        if (this.anz == null) {
            this.anz = new int[]{1};
        } else {
            this.anz[0] = this.anz[0] + 1;
        }
        this.hash.put(s, this.anz);
        this.last[0] = op[0];
        this.last[1] = op[1];
    }
}

