/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences.annotation;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;

public class ReferenceSequenceAnnotation
extends SequenceAnnotation {
    private Sequence ref;
    public static final String TYPE = "reference";

    public ReferenceSequenceAnnotation(String identifier, Sequence ref, Result ... results) {
        super(TYPE, identifier, (Result[][])new Result[][]{results});
        this.ref = ref;
    }

    public ReferenceSequenceAnnotation(StringBuffer representation) throws NonParsableException {
        super(XMLParser.extractForTag(representation, "super"));
        representation = XMLParser.extractForTag(representation, this.getClass().getSimpleName());
        AlphabetContainer cont = (AlphabetContainer)XMLParser.extractObjectForTags(representation, "alphabet");
        try {
            this.ref = Sequence.create(cont, XMLParser.extractObjectForTags(representation, "ref", String.class));
        }
        catch (Exception e) {
            throw new NonParsableException();
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer buf = super.toXML();
        XMLParser.addTags(buf, "super");
        XMLParser.appendObjectWithTags(buf, this.ref.getAlphabetContainer(), "alphabet");
        XMLParser.appendObjectWithTags(buf, this.ref.toString(), "ref");
        XMLParser.addTags(buf, this.getClass().getSimpleName());
        return buf;
    }

    @Override
    public String toString() {
        return super.toString() + this.ref;
    }

    public Sequence getReferenceSequence() {
        return this.ref;
    }
}

