/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.alignment;

import java.util.List;

public class StringAlignment {
    private String[] r;
    private double cost;

    public StringAlignment(double cost, String ... strings) {
        this.cost = cost;
        this.r = (String[])strings.clone();
    }

    public double getCost() {
        return this.cost;
    }

    public int getNumberOfAlignedSequences() {
        return this.r.length;
    }

    public String getAlignedString(int index) {
        return this.r[index];
    }

    public String toString() {
        return this.toString(Integer.MAX_VALUE, -1, null);
    }

    public String toString(int chunkSize, int simplifyIdx, List<String> annot) {
        String[] d;
        StringBuffer buf = new StringBuffer();
        if (simplifyIdx >= 0) {
            StringBuffer[] data = new StringBuffer[this.r.length];
            int[] start = new int[this.r.length];
            int[] end = new int[this.r.length];
            for (int i = 0; i < this.r.length; ++i) {
                int l;
                data[i] = new StringBuffer();
                for (l = 0; l < this.r[i].length() && this.r[i].charAt(l) == '-'; ++l) {
                }
                start[i] = l;
                for (l = this.r[i].length() - 1; l >= 0 && this.r[i].charAt(l) == '-'; --l) {
                }
                end[i] = l;
            }
            int same = 46;
            int border = 32;
            for (int l = 0; l < this.r[simplifyIdx].length(); ++l) {
                for (int i = 0; i < this.r.length; ++i) {
                    data[i].append((char)(i == simplifyIdx ? this.r[i].charAt(l) : (start[i] <= l && l <= end[i] ? (this.r[i].charAt(l) == this.r[simplifyIdx].charAt(l) ? same : (int)this.r[i].charAt(l)) : border)));
                }
            }
            d = new String[this.r.length];
            for (int i = 0; i < this.r.length; ++i) {
                d[i] = data[i].toString();
            }
        } else {
            d = this.r;
        }
        for (int start = 0; start < d[0].length(); start += chunkSize) {
            int end = Math.min(start + chunkSize, d[0].length());
            for (int i = 0; i < this.r.length; ++i) {
                buf.append(d[i].substring(start, end));
                if (annot != null && i < annot.size()) {
                    buf.append("\t");
                    buf.append(annot.get(i));
                }
                buf.append("\n");
            }
            buf.append("\n");
        }
        buf.append("costs: ");
        buf.append(this.cost);
        return buf.toString();
    }

    public int getLength() {
        return this.r[0].length();
    }
}

