/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvarmulti;

import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.randvar.GammaAcceptanceRejectionGen;
import umontreal.iro.lecuyer.randvarmulti.RandomMultivariateGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class DirichletGen
extends RandomMultivariateGen {
    private GammaAcceptanceRejectionGen[] ggens;

    public DirichletGen(RandomStream stream, double[] alphas) {
        if (stream == null) {
            throw new NullPointerException("stream is null");
        }
        this.stream = stream;
        this.dist = null;
        this.dimension = alphas.length;
        this.ggens = new GammaAcceptanceRejectionGen[alphas.length];
        for (int k = 0; k < alphas.length; ++k) {
            this.ggens[k] = new GammaAcceptanceRejectionGen(stream, new GammaDist(alphas[k], 0.5));
        }
    }

    public double getAlpha(int i) {
        return ((GammaDist)this.ggens[i].getDistribution()).getAlpha();
    }

    public static void nextPoint(RandomStream stream, double[] alphas, double[] p) {
        int i;
        double total = 0.0;
        for (i = 0; i < alphas.length; ++i) {
            p[i] = GammaAcceptanceRejectionGen.nextDouble(stream, stream, alphas[i], 0.5);
            total += p[i];
        }
        i = 0;
        while (i < alphas.length) {
            int n = i++;
            p[n] = p[n] / total;
        }
    }

    public void nextPoint(double[] p) {
        int i;
        int n = this.ggens.length;
        double total = 0.0;
        for (i = 0; i < n; ++i) {
            p[i] = this.ggens[i].nextDouble();
            total += p[i];
        }
        i = 0;
        while (i < n) {
            int n2 = i++;
            p[n2] = p[n2] / total;
        }
    }
}

