/*
 * Decompiled with CFR 0.152.
 */
package seqTools;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import java.text.NumberFormat;
import java.util.HashMap;
import seqTools.AbstractChIPper;

public class ViterbiChIPper
extends AbstractChIPper {
    private HashMap<Sequence, int[]> toBeUsedHash;

    public ViterbiChIPper(int starts, DifferentiableStatisticalModel ... motif) throws CloneNotSupportedException {
        super(starts, motif);
        this.init();
    }

    public ViterbiChIPper(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    @Override
    protected void init() {
        super.init();
        this.toBeUsedHash = new HashMap();
    }

    @Override
    public ViterbiChIPper clone() throws CloneNotSupportedException {
        ViterbiChIPper clone = (ViterbiChIPper)super.clone();
        clone.toBeUsedHash = new HashMap();
        for (Sequence s : this.toBeUsedHash.keySet()) {
            clone.toBeUsedHash.put(s, (int[])this.toBeUsedHash.get(s).clone());
        }
        return clone;
    }

    @Override
    protected int fillComponentScoreOf(double[] array, int component, Sequence sequence, int startpos) {
        int m = this.function[component].getLength();
        int end = sequence.getLength() - startpos - m + 1;
        this.componentScore[component] = Double.NEGATIVE_INFINITY;
        if (end > 0) {
            float[] position = this.getPosition(component, sequence, false);
            double pos = Double.NaN;
            if (position == null) {
                pos = -Math.log(end);
            }
            int l = 0;
            while (l < end) {
                if (position != null) {
                    pos = position[startpos];
                }
                array[l] = pos + this.function[component].getLogScoreFor(sequence, startpos) - (double)m * this.logP;
                ++l;
                ++startpos;
            }
            return end;
        }
        return 0;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        double h = (double)(seq.getLength() - start) * this.logP;
        double pos = 0.0;
        int[] b = this.toBeUsedHash.get(seq);
        if (b == null) {
            int i = 0;
            while (i < this.function.length) {
                int m = this.function[i].getLength();
                int end = seq.getLength() - start - m + 1;
                this.componentScore[i] = Double.NEGATIVE_INFINITY;
                if (end > 0) {
                    float[] position = this.getPosition(i, seq, false);
                    if (position == null) {
                        pos = -Math.log(end);
                    }
                    int l = 0;
                    while (l < end) {
                        double current;
                        if (position != null) {
                            pos = position[start];
                        }
                        if ((current = pos + this.function[i].getLogScoreFor(seq, start) - (double)m * this.logP) > this.componentScore[i]) {
                            this.componentScore[i] = current;
                        }
                        ++l;
                        ++start;
                    }
                    int n = i;
                    this.componentScore[n] = this.componentScore[n] + (h + this.logHiddenPotential[i]);
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.function.length) {
                int m = this.function[i].getLength();
                int end = seq.getLength() - start - m + 1;
                float[] position = this.getPosition(i, seq, false);
                pos = position == null ? -Math.log(end) : (double)position[b[i]];
                this.componentScore[i] = h + this.logHiddenPotential[i] + pos + this.function[i].getLogScoreFor(seq, b[i] + start) - (double)m * this.logP;
                ++i;
            }
        }
        this.componentScore[this.function.length] = h + this.logHiddenPotential[this.function.length];
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int n;
        boolean add;
        int startIndex = partialDer.length();
        double pos = Double.NaN;
        int[] b = this.toBeUsedHash.get(seq);
        boolean bl = add = b == null;
        if (add && start == 0) {
            b = new int[this.function.length];
        }
        int j = 0;
        while (j < this.function.length) {
            int best = -1;
            double bestVal = Double.NEGATIVE_INFINITY;
            int m = this.function[j].getLength();
            int stop = seq.getLength() - start - m + 1;
            if (stop > 0) {
                float[] position = this.getPosition(j, seq, true);
                if (position == null) {
                    pos = -Math.log(stop);
                }
                n = 0;
                int l = start;
                while (n < stop) {
                    double current;
                    if (position != null) {
                        pos = position[l];
                    }
                    if ((current = pos + this.function[j].getLogScoreFor(seq, l) - (double)m * this.logP) > bestVal) {
                        bestVal = current;
                        best = n;
                    }
                    ++l;
                    ++n;
                }
                this.componentScore[j] = bestVal;
                b[j] = best;
                if (add && start == 0) {
                    this.toBeUsedHash.put(seq, b);
                }
                this.iList[j].clear();
                this.dList[j].clear();
                this.function[j].getLogScoreAndPartialDerivation(seq, best, this.iList[j], this.dList[j]);
                int n2 = j;
                this.componentScore[n2] = this.componentScore[n2] + this.logHiddenPotential[j];
                int counter = 0;
                while (counter < this.iList[j].length()) {
                    indices.add(this.iList[j].get(counter) + this.paramRef[j]);
                    partialDer.add(this.dList[j].get(counter));
                    ++counter;
                }
            } else {
                this.componentScore[j] = Double.NEGATIVE_INFINITY;
            }
            this.endIndex[j] = partialDer.length();
            ++j;
        }
        this.componentScore[this.function.length] = this.logHiddenPotential[this.function.length];
        double logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.componentScore.length, this.componentScore, 0);
        j = 0;
        while (j < this.function.length) {
            partialDer.multiply(startIndex, this.endIndex[j], this.componentScore[j]);
            startIndex = this.endIndex[j];
            ++j;
        }
        logScore += this.logP * (double)(seq.getLength() - start);
        n = this.function.length;
        int i = this.paramRef[n + 1] - this.paramRef[n];
        j = 0;
        while (j < i) {
            indices.add(this.paramRef[n] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
            ++j;
        }
        return logScore;
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public /* synthetic */ String toString(NumberFormat numberFormat) {
        throw new Error("Unresolved compilation problem: \n\tThe type ViterbiChIPper must implement the inherited abstract method SequenceScore.toString(NumberFormat)\n");
    }
}

