/*
 * Decompiled with CFR 0.152.
 */
package seqTools;

import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.ToolBox;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import seqTools.AbstractChIPper;

public class FastAbsThresholdedChIPper
extends AbstractChIPper {
    private double[] scoreProfile;
    private double[] normedProfile;
    private IntList tempPos;
    private IntList end;
    private double threshold;
    private HashMap<Sequence, IntList[]> toBeUsedHash;

    public FastAbsThresholdedChIPper(int starts, double t, DifferentiableStatisticalModel ... motif) throws CloneNotSupportedException {
        super(starts, motif);
        if (t <= 0.0 || t > 1.0) {
            throw new IllegalArgumentException();
        }
        this.threshold = t;
        this.init();
    }

    public FastAbsThresholdedChIPper(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.init();
    }

    @Override
    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
        this.threshold = (Double)XMLParser.extractObjectForTags(xml, "threshold");
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer extra = new StringBuffer(100);
        XMLParser.appendObjectWithTags(extra, this.threshold, "threshold");
        return extra;
    }

    @Override
    protected void init() {
        super.init();
        this.end = new IntList();
        this.tempPos = new IntList();
        this.toBeUsedHash = new HashMap();
    }

    @Override
    public FastAbsThresholdedChIPper clone() throws CloneNotSupportedException {
        FastAbsThresholdedChIPper clone = (FastAbsThresholdedChIPper)super.clone();
        if (this.scoreProfile != null) {
            clone.scoreProfile = (double[])this.scoreProfile.clone();
        }
        if (this.normedProfile != null) {
            clone.normedProfile = (double[])this.normedProfile.clone();
        }
        clone.end = this.end.clone();
        clone.tempPos = this.tempPos.clone();
        clone.toBeUsedHash = new HashMap();
        System.out.println("c1");
        System.out.flush();
        Iterator<Sequence> it = this.toBeUsedHash.keySet().iterator();
        System.out.println("c2");
        System.out.flush();
        while (it.hasNext()) {
            Sequence s = it.next();
            IntList[] list = this.toBeUsedHash.get(s);
            IntList[] clonedList = new IntList[list.length];
            int i = 0;
            while (i < list.length) {
                if (list[i] != null) {
                    clonedList[i] = list[i].clone();
                }
                ++i;
            }
            clone.toBeUsedHash.put(s, clonedList);
        }
        System.out.println("c3");
        System.out.flush();
        return clone;
    }

    @Override
    protected int fillComponentScoreOf(double[] array, int component, Sequence sequence, int startpos) {
        int end = this.fillComponentScoreOf(array, component, sequence, startpos, null, false);
        return end;
    }

    protected int fillComponentScoreOf(int i, Sequence seq, int start, IntList b, boolean usePosition) {
        int m = this.function[i].getLength();
        int end = seq.getLength() - start - m + 1;
        if (this.scoreProfile == null || this.scoreProfile.length < end) {
            this.scoreProfile = new double[seq.getLength()];
        }
        return this.fillComponentScoreOf(this.scoreProfile, i, seq, start, b, usePosition);
    }

    protected int fillComponentScoreOf(double[] array, int i, Sequence seq, int start, IntList b, boolean usePosition) {
        int m = this.function[i].getLength();
        int end = seq.getLength() - start - m + 1;
        double pos = 0.0;
        float[] position = null;
        if (usePosition && (position = this.getPosition(i, seq, false)) == null) {
            pos = -Math.log(end);
        }
        int j = 0;
        int curr = -1;
        int n = b == null ? end : b.length();
        int l = 0;
        while (l < n) {
            curr = b != null ? b.get(l) : start + l;
            if (curr >= start && curr <= seq.getLength() - m) {
                if (position != null) {
                    pos = position[curr];
                }
                array[j++] = pos + this.function[i].getLogScoreFor(seq, curr) - (double)m * this.logP;
            }
            ++l;
        }
        return j;
    }

    @Override
    protected void fillComponentScores(Sequence seq, int start) {
        double h = (double)(seq.getLength() - start) * this.logP;
        IntList[] b = this.toBeUsedHash.get(seq);
        int i = 0;
        while (i < this.function.length) {
            int j = this.fillComponentScoreOf(i, seq, start, b == null ? null : b[i], true);
            this.componentScore[i] = h + this.logHiddenPotential[i] + Normalisation.getLogSum(0, j, this.scoreProfile);
            ++i;
        }
        this.componentScore[this.function.length] = h + this.logHiddenPotential[this.function.length];
    }

    @Override
    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        int n;
        boolean add;
        int startIndex = partialDer.length();
        double pos = Double.NaN;
        IntList[] b = this.toBeUsedHash.get(seq);
        boolean bl = add = b == null;
        if (add && start == 0) {
            b = new IntList[this.function.length];
        }
        int i = 0;
        while (i < this.function.length) {
            if (!add) {
                b[i].clear();
            } else if (start == 0) {
                b[i] = new IntList();
            }
            ++i;
        }
        int j = 0;
        while (j < this.function.length) {
            int m = this.function[j].getLength();
            int stop = seq.getLength() - start - m + 1;
            if (stop > 0) {
                float[] position = this.getPosition(j, seq, true);
                if (position == null) {
                    pos = -Math.log(stop);
                }
                if (this.scoreProfile == null || this.scoreProfile.length < stop) {
                    this.scoreProfile = new double[seq.getLength()];
                }
                n = 0;
                int l = start;
                while (n < stop) {
                    if (position != null) {
                        pos = position[l];
                    }
                    this.scoreProfile[n] = pos + this.function[j].getLogScoreFor(seq, l) - (double)m * this.logP;
                    ++l;
                    ++n;
                }
                int e = stop - 1;
                double best = ToolBox.max(0, stop, this.scoreProfile);
                double t = best + Math.log(this.threshold);
                int k = 0;
                this.iList[j].clear();
                this.dList[j].clear();
                this.end.clear();
                this.tempPos.clear();
                e = 0;
                while (e < stop) {
                    if (this.scoreProfile[e] >= t) {
                        this.tempPos.add(e);
                        this.function[j].getLogScoreAndPartialDerivation(seq, start + e, this.iList[j], this.dList[j]);
                        if (b != null) {
                            b[j].add(e);
                        }
                    }
                    this.end.add(this.iList[j].length());
                    ++e;
                }
                if (this.normedProfile == null || this.normedProfile.length < this.tempPos.length()) {
                    this.normedProfile = new double[this.tempPos.length()];
                }
                k = 0;
                while (k < this.tempPos.length()) {
                    this.normedProfile[k] = this.scoreProfile[this.tempPos.get(k)];
                    ++k;
                }
                if (add && start == 0) {
                    this.toBeUsedHash.put(seq, b);
                }
                this.componentScore[j] = Normalisation.logSumNormalisation(this.normedProfile, 0, k);
                k = 0;
                int n2 = j;
                this.componentScore[n2] = this.componentScore[n2] + this.logHiddenPotential[j];
                k = 0;
                int counter = 0;
                while (k < this.tempPos.length()) {
                    l = this.tempPos.get(k);
                    e = this.end.get(l);
                    if (l > 0) {
                        counter = this.end.get(l - 1);
                    }
                    while (counter < e) {
                        indices.add(this.iList[j].get(counter) + this.paramRef[j]);
                        partialDer.add(this.dList[j].get(counter++) * this.normedProfile[k]);
                    }
                    ++k;
                }
            } else {
                this.componentScore[j] = Double.NEGATIVE_INFINITY;
            }
            this.endIndex[j] = partialDer.length();
            ++j;
        }
        this.componentScore[this.function.length] = this.logHiddenPotential[this.function.length];
        double logScore = Normalisation.logSumNormalisation(this.componentScore, 0, this.componentScore.length, this.componentScore, 0);
        j = 0;
        while (j < this.function.length) {
            partialDer.multiply(startIndex, this.endIndex[j], this.componentScore[j]);
            startIndex = this.endIndex[j];
            ++j;
        }
        logScore += this.logP * (double)(seq.getLength() - start);
        n = this.function.length;
        int i2 = this.paramRef[n + 1] - this.paramRef[n];
        j = 0;
        while (j < i2) {
            indices.add(this.paramRef[n] + j);
            partialDer.add(this.componentScore[j] - (this.isNormalized() ? this.hiddenPotential[j] : 0.0));
            ++j;
        }
        return logScore;
    }

    @Override
    public String getInstanceName() {
        return String.valueOf(this.getClass().getSimpleName()) + "(" + this.function[0].getInstanceName() + ")";
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile kind) throws Exception {
        if (motif == 0 && component < this.function.length) {
            double[] res;
            int end = this.fillComponentScoreOf(component, sequence, startpos, null, false);
            double d = 0.0;
            int l = sequence.getLength() - startpos - this.function[component].getLength();
            if (l > 0) {
                switch (kind) {
                    case UNNORMALIZED_JOINT: {
                        d = this.logHiddenPotential[component];
                    }
                    case UNNORMALIZED_CONDITIONAL: {
                        break;
                    }
                    case NORMALIZED_CONDITIONAL: {
                        d = -Normalisation.getLogSum(0, end, this.scoreProfile);
                        break;
                    }
                    default: {
                        throw new IndexOutOfBoundsException();
                    }
                }
                res = new double[l + 1];
                int i = 0;
                while (i < res.length) {
                    res[i] = this.scoreProfile[i] + d;
                    ++i;
                }
            } else {
                res = new double[]{};
            }
            return res;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public /* synthetic */ String toString(NumberFormat numberFormat) {
        throw new Error("Unresolved compilation problem: \n\tThe type FastAbsThresholdedChIPper must implement the inherited abstract method SequenceScore.toString(NumberFormat)\n");
    }
}

