/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.GFFParser;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Pair;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.talGA.MatchFinder;
import projects.talGA.SimpleMatchFinder;
import projects.talGA.TALENTargetFinder;
import projects.tals.FastTALENScanner;
import projects.tals.LimitedSortedList;
import projects.tals.TALgetterDiffSM;

public class SlowTALENScanner {
    public ListResult[] scan(TALgetterDiffSM model, FastTALENScanner.FastTALENScannerParameterSet params, BufferedReader dsRead, GFFParser.GFFList gff, int ignored) throws Exception {
        if (!params.hasDefaultOrIsSet()) {
            System.err.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        Sequence talLeft = Sequence.create(alphabetsRVD, params.getLeftTALSequence(), "-");
        Sequence talRight = Sequence.create(alphabetsRVD, params.getRightTALSequence(), "-");
        int minDist = params.getMinimumDistance();
        int maxDist = params.getMaximumDistance();
        ResultList rl = new ResultList(params.getN());
        ListResult rl2 = new ListResult("", "", null, new ResultSet[0]);
        StringBuffer lastHeader = new StringBuffer();
        Pair<int[][], DataSet> curr = null;
        SimpleMatchFinder singleFind = new SimpleMatchFinder(null, model);
        TALENTargetFinder finder = new TALENTargetFinder(null, model, singleFind);
        double bestTotal = model.getBestPossibleScore(talLeft, null) + model.getBestPossibleScore(talRight, null);
        double th = 0.4;
        double totalThresh = model.getBestPossibleScore(talLeft, null) / (double)(talLeft.getLength() + 1) + model.getBestPossibleScore(talRight, null) / (double)(talRight.getLength() + 1) + 2.0 * Math.log(th);
        double singleThresh1 = model.getBestPossibleScore(talLeft, null) / (double)(talLeft.getLength() + 1) + Math.log(th * 0.9);
        double singleThresh2 = model.getBestPossibleScore(talRight, null) / (double)(talRight.getLength() + 1) + Math.log(th * 0.9);
        Sequence test1 = Sequence.create(DNAAlphabetContainer.SINGLETON, "TACTAGTATTATTACT");
        Sequence test2 = Sequence.create(DNAAlphabetContainer.SINGLETON, "TGTCCTAAACAAAGAT");
        System.out.println(String.valueOf(model.getMatchString(talLeft, test1)) + " " + model.getPartialLogScoreFor(talLeft, test1, 0, 0, test1.getLength()) / (double)(talLeft.getLength() + 1) + " " + model.getBestPossibleScore(talLeft, null));
        System.out.println(String.valueOf(model.getMatchString(talRight, test2)) + " " + model.getPartialLogScoreFor(talRight, test2, 0, 0, test2.getLength()) / (double)(talRight.getLength() + 1) + " " + model.getBestPossibleScore(talRight, null));
        System.out.println(String.valueOf(model.getPartialLogScoreFor(talLeft, test1, 0, 0, test1.getLength()) + model.getPartialLogScoreFor(talRight, test2, 0, 0, test2.getLength())) + " " + (model.getBestPossibleScore(talLeft, null) + model.getBestPossibleScore(talRight, null)));
        LinkedList<GFFParser.GFFEntry> en = new LinkedList<GFFParser.GFFEntry>();
        long size = 0L;
        while ((curr = this.readNextSequences(dsRead, lastHeader)) != null) {
            int[][] offsets = curr.getFirstElement();
            DataSet dat = curr.getSecondElement();
            int i = 0;
            while (i < dat.getNumberOfElements()) {
                size += (long)dat.getElementAt(i).getLength();
                ++i;
            }
            finder.setDataSet(dat);
            System.out.println(dat.getElementAt(0).getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue());
            LimitedSortedList<TALENTargetFinder.TALENMatch> list = finder.getTALENMatches(talLeft, talRight, totalThresh, singleThresh1, singleThresh2, minDist, maxDist, params.getN(), true);
            System.out.println(String.valueOf(list.getBestScore()) + " <-> " + list.getWorstScore() + " ? " + rl.getWorstScore());
            ComparableElement<TALENTargetFinder.TALENMatch, Double>[] matches = list.getSortedList();
            int i2 = matches.length - 1;
            while (i2 >= 0 && rl.better(matches[i2].getWeight())) {
                TALENTargetFinder.TALENMatch match = matches[i2].getElement();
                double score = matches[i2].getWeight();
                Sequence tal1 = match.getTal1();
                Sequence tal2 = match.getTal2();
                MatchFinder.Match match1 = match.getMatch1();
                MatchFinder.Match match2 = match.getMatch2();
                Sequence seq1 = dat.getElementAt(match1.getSeqIdx());
                Sequence seq2 = dat.getElementAt(match2.getSeqIdx());
                int pos1 = match1.getSeqPos();
                int pos2 = match2.getSeqPos();
                String id = (String)seq1.getSequenceAnnotationByType("unparsed comment line", 0).getResultForName("unparsed comment").getValue();
                int space = (id = id.trim()).indexOf(32);
                if (space >= 0) {
                    id = id.substring(0, space);
                }
                int start = pos1 + offsets[0][match1.getSeqIdx()] + 1;
                int end = pos2 + tal2.getLength() + offsets[0][match2.getSeqIdx()];
                String featString = SlowTALENScanner.getFeatString(id, start, end, gff);
                String archString = String.valueOf(tal1.equals(talLeft) ? "left" : "right") + "-" + (tal2.equals(talLeft) ? "left" : "right");
                int dist = pos2 - (pos1 + tal1.getLength() + 1);
                Sequence sub1 = seq1.getSubSequence(pos1, tal1.getLength() + 1);
                Sequence sub2 = seq2.reverseComplement().getSubSequence(seq2.getLength() - pos2 - (tal2.getLength() + 1), tal2.getLength() + 1);
                Sequence between = seq1.getSubSequence(pos1 + tal1.getLength() + 1, dist);
                String site = String.valueOf(sub1.toString().toUpperCase()) + between.toString().toLowerCase() + sub2.reverseComplement().toString().toUpperCase();
                String str1 = model.getMatchString(tal1, sub1);
                String str2 = model.getMatchString(tal2, sub2);
                Result[] tr = new Result[]{new CategoricalResult("ID", "", id), new NumericalResult("Position 1", "", pos1 + offsets[0][match1.getSeqIdx()]), new NumericalResult("Position 2", "", pos2 + offsets[0][match2.getSeqIdx()]), new NumericalResult("Distance", "", dist), new CategoricalResult("Sequence 1", "", sub1.toString()), new CategoricalResult("Matches 1", "", str1), new CategoricalResult("Sequence 2", "", sub2.toString()), new CategoricalResult("Matches 2", "", str2), new CategoricalResult("Architecture", "", archString), new CategoricalResult("Full site", "", site), new NumericalResult("Score", "", score), new CategoricalResult("Features", "", featString)};
                rl.add(new ResultSet(new Result[][]{tr}), score);
                if (params.getOutput() != FastTALENScanner.Output.NONE) {
                    String predId = String.valueOf(id) + "_" + start + "_" + end + "_" + archString;
                    en.add(new GFFParser.GFFEntry(id, "TALoffer", "TALEN_dimer_target", start, end, score, StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN, -1, "ID=" + predId + "; group=" + predId));
                    en.add(new GFFParser.GFFEntry(id, "TALoffer", "TALEN_monomer_target", pos1 + offsets[0][match1.getSeqIdx()] + 1, pos1 + offsets[0][match1.getSeqIdx()] + tal1.getLength() + 1, score, StrandedLocatedSequenceAnnotationWithLength.Strand.FORWARD, -1, "Parent=" + predId + "; group=" + predId + "f"));
                    en.add(new GFFParser.GFFEntry(id, "TALoffer", "TALEN_monomer_target", pos2 + offsets[0][match2.getSeqIdx()] + 1, pos2 + offsets[0][match2.getSeqIdx()] + tal2.getLength() + 1, score, StrandedLocatedSequenceAnnotationWithLength.Strand.REVERSE, -1, "Parent=" + predId + "; group=" + predId + "r"));
                }
                --i2;
            }
            if (rl.getWorstScore() > totalThresh) {
                totalThresh = rl.getWorstScore();
            }
            if (totalThresh - model.getBestPossibleScore(talRight, null) / (double)(talRight.getLength() + 1) > singleThresh1) {
                singleThresh1 = totalThresh - model.getBestPossibleScore(talRight, null) / (double)(talRight.getLength() + 1);
            }
            if (!(totalThresh - model.getBestPossibleScore(talLeft, null) / (double)(talLeft.getLength() + 1) > singleThresh2)) continue;
            singleThresh2 = totalThresh - model.getBestPossibleScore(talLeft, null) / (double)(talLeft.getLength() + 1);
        }
        if (params.getOutput() != FastTALENScanner.Output.NONE) {
            rl2 = new GFFParser.GFFList(en).toListResult("Off target predictions (" + params.getOutput().name() + ")", "", params.getOutput() == FastTALENScanner.Output.GFF3);
        }
        System.out.println("input size: " + size);
        return new ListResult[]{new ListResult("Off target predictions", "The off targets predicted for TALENs " + params.getLeftTALSequence() + " and " + params.getRightTALSequence() + " with distance between " + params.getMinimumDistance() + " and " + params.getMaximumDistance(), null, rl.toArray()), rl2};
    }

    private static String getFeatString(String id, int start, int end, GFFParser.GFFList gff) {
        String featString = "";
        if (gff != null) {
            GFFParser.GFFList sub = gff.getSubList(id);
            ArrayList<GFFParser.GFFEntry> feats = sub.getEntriesOverlapping(start, end);
            ArrayList<GFFParser.GFFEntry> feats2 = new ArrayList<GFFParser.GFFEntry>();
            if (feats != null) {
                ArrayList<GFFParser.GFFEntry> parents = new ArrayList<GFFParser.GFFEntry>();
                LinkedList<GFFParser.GFFEntry> stack = new LinkedList<GFFParser.GFFEntry>();
                int j = 0;
                while (j < feats.size()) {
                    LinkedList<GFFParser.GFFEntry> temp = feats.get(j).getParents();
                    if (temp != null) {
                        stack.addAll(temp);
                    }
                    ++j;
                }
                while (stack.size() > 0) {
                    GFFParser.GFFEntry temp = (GFFParser.GFFEntry)stack.pop();
                    parents.add(temp);
                    LinkedList<GFFParser.GFFEntry> temp2 = temp.getParents();
                    if (temp2 == null) continue;
                    stack.addAll(temp2);
                }
                j = 0;
                while (j < feats.size()) {
                    if (!parents.contains(feats.get(j)) && feats.get(j).getParsedType() != GFFParser.GFFEntry.GFFType.chromosome) {
                        feats2.add(feats.get(j));
                    }
                    ++j;
                }
                if (feats2.size() > 0) {
                    featString = feats2.toString();
                    featString = featString.substring(1, featString.length() - 1);
                }
            }
        }
        return featString;
    }

    public Pair<int[][], DataSet> readNextSequences(BufferedReader read, StringBuffer lastHeader) throws Exception {
        String str = null;
        StringBuffer line = new StringBuffer();
        IntList starts = new IntList();
        IntList ends = new IntList();
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        int size = 0;
        while ((str = read.readLine()) != null || line.length() > 0) {
            if (str != null) {
                str = str.trim();
            }
            if (str == null || str.startsWith(">")) {
                String header = lastHeader.toString();
                if (str != null) {
                    lastHeader.delete(0, lastHeader.length());
                    lastHeader.append(str.substring(1));
                }
                if (line.length() <= 0) continue;
                String seqStr = line.toString();
                line.delete(0, line.length());
                Matcher match = acgt.matcher(seqStr);
                while (match.find()) {
                    int start = match.start();
                    int end = match.end();
                    SequenceAnnotation annotation = new SequenceAnnotation("unparsed comment line", "unparsed comment line", new CategoricalResult("unparsed comment", "unparsed comment", header));
                    Sequence seq = new SparseSequence((AlphabetContainer)DNAAlphabetContainer.SINGLETON, seqStr.substring(start, end));
                    seq = seq.annotate(false, annotation);
                    seqs.add(seq);
                    size += seq.getLength();
                    starts.add(start);
                    ends.add(seqStr.length() - end);
                }
                if (!((double)size > 1.0E7) && str != null) continue;
                return new Pair<int[][], DataSet>(new int[][]{starts.toArray(), ends.toArray()}, new DataSet("", seqs));
            }
            line.append(str);
        }
        return null;
    }

    private static HashSet<Sequence> makeHash(DataSet d) {
        HashSet<Sequence> set = new HashSet<Sequence>();
        int i = 0;
        while (i < d.getNumberOfElements()) {
            set.add(d.getElementAt(i));
            ++i;
        }
        return set;
    }

    public static class ResultList {
        private ComparableElement<ResultSet, Double>[] list;
        private int curr;

        public ResultList(int n) {
            this.list = new ComparableElement[n];
            this.curr = 0;
        }

        public boolean better(double value) {
            if (this.list[this.curr] == null) {
                return true;
            }
            return -value < this.list[this.curr].getWeight();
        }

        public void add(ResultSet res, double value) {
            if (this.list[this.curr] == null) {
                this.list[this.curr] = new ComparableElement<ResultSet, Double>(res, -value);
                if (this.curr < this.list.length - 1) {
                    ++this.curr;
                    Arrays.sort(this.list, 0, this.curr);
                } else {
                    Arrays.sort(this.list);
                }
            } else if (-value < this.list[this.curr].getWeight()) {
                this.list[this.curr] = new ComparableElement<ResultSet, Double>(res, -value);
                Arrays.sort(this.list);
            }
        }

        public DataSet getBindingSites() throws Exception {
            if (this.getNumberOfResults() == 0) {
                return null;
            }
            Sequence[] seqs = new Sequence[this.getNumberOfResults()];
            int i = 0;
            while (i < seqs.length) {
                seqs[i] = Sequence.create(DNAAlphabetContainer.SINGLETON, new SequenceAnnotation[]{new SequenceAnnotation("ID", (String)this.list[i].getElement().getResultForName("ID").getValue(), (Result[][])new Result[0][]), new SequenceAnnotation("Position", this.list[i].getElement().getResultForName("Position").getValue().toString(), (Result[][])new Result[0][]), new SequenceAnnotation("Score", this.list[i].getElement().getResultForName("Score").getValue().toString(), (Result[][])new Result[0][])}, (String)this.list[i].getElement().getResultForName("Sequence").getValue(), "");
                ++i;
            }
            return new DataSet("binding sites", seqs);
        }

        public ResultSet[] toArray() {
            ResultSet[] res = new ResultSet[this.getNumberOfResults()];
            int i = 0;
            while (i < res.length) {
                res[i] = this.list[i].getElement();
                ++i;
            }
            return res;
        }

        public double getBestScore() {
            if (this.list[0] == null) {
                return Double.NEGATIVE_INFINITY;
            }
            return -this.list[0].getWeight().doubleValue();
        }

        public double getWorstScore() {
            if (this.curr == 0 && this.list[this.curr] == null) {
                return Double.NEGATIVE_INFINITY;
            }
            if (this.list[this.curr] == null) {
                return -this.list[this.curr - 1].getWeight().doubleValue();
            }
            return -this.list[this.curr].getWeight().doubleValue();
        }

        public int getNumberOfResults() {
            if (this.list[this.curr] == null) {
                return this.curr;
            }
            return this.curr + 1;
        }
    }
}

