/*
 * Decompiled with CFR 0.152.
 */
package projects.tals;

import de.jstacs.DataType;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.ListResult;
import de.jstacs.results.ResultSet;
import java.io.InputStreamReader;
import projects.tals.ScanForTBSCLI2;
import projects.tals.TALTrainer;
import projects.tals.TALgetterDiffSM;
import projects.tals.TBSScanner;

public class ScanForTBSCLIcv {
    public static void main(String[] args) throws Exception {
        TBSScanner.TBSScannerParameterSet params = new TBSScanner.TBSScannerParameterSet();
        SimpleParameterSet tempPars = new SimpleParameterSet(new SimpleParameter(DataType.STRING, "Input sequences", "The sequences to scan for TAL binding sites, FastA", true), params.getParameterForName("RVD sequence"), params.getParameterForName("Upstream offset"), params.getParameterForName("Downstream offset"), params.getParameterForName("Maximum number of target sites"), new EnumParameter(TBSScanner.PVals.class, "Computation of p-Values", true, TBSScanner.PVals.COARSE.name()), new SimpleParameter(DataType.DOUBLE, "p-Value", "Filter the reported hits by a maximum p-Value. A value of 0 or 1 switches off the filter.", true, new NumberValidator<Double>(0.0, 1.0), 1.0));
        ParameterSetTagger pst = new ParameterSetTagger(new String[]{"input", "tal", "fp", "do", "top", "pval", "pthresh"}, tempPars);
        pst.fillParameters("=", args);
        System.err.println("parameters:");
        System.err.println(pst);
        System.err.println("_________________________________");
        if (!tempPars.hasDefaultOrIsSet()) {
            System.err.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        params.setInputPath((String)tempPars.getParameterAt(0).getValue());
        if (tempPars.getParameterAt(5).getValue() == TBSScanner.PVals.FINE) {
            params.getParameterForName("Computation of p-Values").setValue("Fine-grained p-Values (slower but more accurate)");
            ((ParameterSet)params.getParameterForName("Computation of p-Values").getValue()).getParameterAt(0).setValue(tempPars.getParameterAt(6).getValue());
        } else if (tempPars.getParameterAt(5).getValue() == TBSScanner.PVals.COARSE) {
            params.getParameterForName("Computation of p-Values").setValue("Coarse p-Values (faster but less accurate)");
            ((ParameterSet)params.getParameterForName("Computation of p-Values").getValue()).getParameterAt(0).setValue(tempPars.getParameterAt(6).getValue());
        } else {
            params.getParameterForName("Computation of p-Values").setValue("No p-Values (fastest)");
        }
        DataSet ds = params.getInputSequences();
        System.err.println("Searching for targets of TAL effector sequence");
        System.err.println("\t" + params.getTALSequence() + ".\n");
        System.err.println("Reporting at most " + params.getN() + " target sites in " + ds.getNumberOfElements() + " input sequences.\n\n");
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        Sequence tal = Sequence.create(alphabetsRVD, params.getTALSequence(), "-");
        TALgetterDiffSM model = TALTrainer.getTALFinder(new InputStreamReader(ScanForTBSCLI2.class.getClassLoader().getResourceAsStream("projects/tals/targetsSF.fasta")), new InputStreamReader(ScanForTBSCLI2.class.getClassLoader().getResourceAsStream("projects/tals/targetsGewichte.txt")), new Sequence[]{tal}, true);
        model.fix();
        TBSScanner.ResultList[] rls = TBSScanner.scan(model, params, ds);
        ResultSet[] res = rls[0].toArray();
        System.out.println(new ListResult("Predictions", "", null, res));
        System.err.println("Finished...");
    }
}

