/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.REnvironment;
import projects.talGA.InfixMatchFinder;
import projects.talGA.MatchFinder;
import projects.talGA.TALDesigner;
import projects.tals.LimitedSortedList;
import projects.tals.TALgetterDiffSM;

public class TALProfile {
    public static void main(String[] args) throws Exception {
        TALgetterDiffSM talFunction = (TALgetterDiffSM)XMLParser.extractObjectForTags(FileManager.readInputStream(TALProfile.class.getClassLoader().getResourceAsStream("projects/tals/talfinder_obg2_hyp_bg.xml")), "model");
        talFunction.fix();
        DNADataSet ds = new DNADataSet(args[0]);
        DataSet bg = TALDesigner.readFile(args[1], ds)[0];
        Sequence tal = Sequence.create(talFunction.getRVDAlphabet(), args[2], "-");
        System.out.println(talFunction.getBestPossibleScore(tal, null));
        String outpath = args[3];
        int length = tal.getLength();
        InfixMatchFinder backFinder = new InfixMatchFinder(bg, Math.min(9, length), talFunction);
        Sequence seq = ds.getElementAt(0);
        int natuIdx = -1;
        double bestScNatu = Double.NEGATIVE_INFINITY;
        double[] scBest = new double[seq.getLength() - length];
        double[] numOffTargets = new double[seq.getLength() - length];
        double[] bestOffTargetScore = new double[seq.getLength() - length];
        double[] natuScores = new double[seq.getLength() - length];
        int j = 0;
        while (j < seq.getLength() - length) {
            Sequence sub = seq.getSubSequence(j, length + 1);
            Sequence talBest = talFunction.getBestRVDsFor(sub, null);
            double bestPossible = talFunction.getBestPossibleScore(talBest, null);
            scBest[j] = talFunction.getPartialLogScoreFor(talBest, sub, 0, 0, sub.getLength());
            double scNatu = talFunction.getPartialLogScoreFor(tal, sub, 0, 0, sub.getLength());
            if (scNatu > bestScNatu) {
                bestScNatu = scNatu;
                natuIdx = j;
            }
            natuScores[j] = scNatu;
            LimitedSortedList<MatchFinder.Match> matches = ((MatchFinder)backFinder).getScoresAbove(talBest, bestPossible - (double)(talBest.getLength() + 1) * Math.log(2.0), 10000, true, false);
            numOffTargets[j] = matches.getLength();
            bestOffTargetScore[j] = matches.getBestScore();
            System.out.println("best:");
            System.out.println(talBest);
            System.out.println(talFunction.getMatchString(talBest, sub));
            System.out.println(sub);
            System.out.println();
            MatchFinder.Match match = matches.getBestElement();
            System.out.println(talBest);
            if (match != null) {
                Sequence sub2 = bg.getElementAt(match.getSeqIdx()).getSubSequence(match.getSeqPos(), talBest.getLength() + 1);
                System.out.println(talFunction.getMatchString(talBest, sub2));
                System.out.println(sub2);
                System.out.println(String.valueOf(talFunction.getPartialLogScoreFor(talBest, sub2, 0, 0, talBest.getLength() + 1)) + " <-> " + (bestPossible - (double)(talBest.getLength() + 1) * Math.log(2.0)));
            }
            System.out.println("+++++++++++++++++++++++++++++++++");
            ++j;
        }
        double bestPossible = talFunction.getBestPossibleScore(tal, null);
        LimitedSortedList<MatchFinder.Match> matches = ((MatchFinder)backFinder).getScoresAbove(tal, bestPossible - (double)(tal.getLength() + 1) * Math.log(2.0), 10000, true, false);
        System.out.println(tal);
        System.out.println(talFunction.getMatchString(tal, seq.getSubSequence(natuIdx, tal.getLength() + 1)));
        System.out.println(seq.getSubSequence(natuIdx, tal.getLength() + 1));
        System.out.println();
        MatchFinder.Match match = matches.getBestElement();
        if (match != null) {
            System.out.println(tal);
            Sequence sub2 = bg.getElementAt(match.getSeqIdx()).getSubSequence(match.getSeqPos(), tal.getLength() + 1);
            System.out.println(talFunction.getMatchString(tal, sub2));
            System.out.println(sub2);
        }
        REnvironment re = new REnvironment();
        re.createVector("sc.best", scBest);
        re.createVector("num.off", numOffTargets);
        re.createVector("best.off.score", bestOffTargetScore);
        re.createVector("natu.scores", natuScores);
        re.voidEval("idx<-" + (natuIdx + 1));
        re.voidEval("natu.score<-" + bestScNatu);
        re.voidEval("natu.off<-" + matches.getLength());
        re.voidEval("natu.off.score<-" + matches.getBestScore());
        StringBuffer plots = new StringBuffer();
        plots.append("plot(sc.best,t=\"l\",xlab=\"position\",ylab=\"score\");points(idx,natu.score,col=2,lwd=2);");
        plots.append("plot(natu.scores,t=\"l\",xlab=\"position\",ylab=\"natural score\");points(idx,natu.score,col=2,lwd=2);");
        plots.append("plot(num.off,t=\"l\",xlab=\"position\",ylab=\"off targets\",log=\"y\");points(idx,natu.off,col=2,lwd=2);");
        plots.append("plot(best.off.score,t=\"l\",xlab=\"position\",ylab=\"off target score\");points(idx,natu.off.score,col=2,lwd=2);");
        plots.append("plot(sc.best-best.off.score,t=\"l\",xlab=\"position\",ylab=\"diff scores\");points(idx,natu.score-natu.off.score,col=2,lwd=2);");
        re.plotToPDF(plots.toString(), 12.0, 5.0, outpath, true);
    }
}

