/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.initialization.PopulationInitializer;
import de.jstacs.optimization.geneticAlgorithms.populations.DiscreteSequencePopulation;
import de.jstacs.optimization.geneticAlgorithms.populations.Population;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import java.util.LinkedList;
import java.util.Random;
import projects.talGA.TALENIndividual;

public class TALENPopulationInitializer
implements PopulationInitializer<DiscreteSequenceIndividual> {
    private static Random r = new Random();
    private int length;
    private boolean homo;
    private AlphabetContainer cont;
    private int[] allowed;

    public TALENPopulationInitializer(int length, boolean homo, AlphabetContainer cont, int[] allowed) {
        this.length = length;
        this.homo = homo;
        this.cont = cont;
        this.allowed = (int[])allowed.clone();
    }

    @Override
    public Population<DiscreteSequenceIndividual> getInitialPopulation(int num, FitnessFunction<DiscreteSequenceIndividual> fun) throws Exception {
        LinkedList<TALENIndividual> indiv = new LinkedList<TALENIndividual>();
        int i = 0;
        while (i < num) {
            int[] seq = new int[this.length];
            int j = 0;
            while (j < seq.length) {
                seq[j] = this.allowed[r.nextInt(this.allowed.length)];
                ++j;
            }
            TALENIndividual temp = new TALENIndividual(new IntSequence(this.cont, seq), this.homo);
            temp.setFitness((FitnessFunction)fun);
            indiv.add(temp);
            ++i;
        }
        return new DiscreteSequencePopulation(indiv.toArray(new DiscreteSequenceIndividual[0]));
    }
}

