/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.utils.SafeOutputStream;
import java.util.LinkedList;
import projects.talGA.TALENFitnessFunction;
import projects.talGA.TALENIndividual;
import projects.tals.TALgetterDiffSM;

public class TALENMatchFitnessFunction
extends TALENFitnessFunction {
    public TALENMatchFitnessFunction(DataSet positives, TALgetterDiffSM fun, int minDist, int maxDist) throws CloneNotSupportedException {
        super(fun, positives, minDist, maxDist);
    }

    @Override
    public void setOutputStream(SafeOutputStream stream) {
        this.out = stream;
    }

    @Override
    public Double getFitness(DiscreteSequenceIndividual individual) throws Exception {
        TALENIndividual talen = (TALENIndividual)individual;
        double minScore = Double.POSITIVE_INFINITY;
        LinkedList<double[]> scores = new LinkedList<double[]>();
        int minNumMatches = this.getTALENMatches(individual, null, null, scores);
        int i = 0;
        while (i < scores.size()) {
            double[] temp = scores.get(i);
            if (temp[2] < minScore) {
                minScore = temp[2];
            }
            ++i;
        }
        this.out.writeln("minScore: " + minScore);
        System.out.println("minScore: " + minScore);
        minScore /= (double)talen.getTALENDimension() + 2.0;
        System.out.println("match: " + 1.0 / (1.0 + Math.exp(-10.0 * (minScore -= Math.log(0.5)))));
        return 1.0 / (1.0 + Math.exp(-10.0 * minScore));
    }

    @Override
    public void reset() {
    }
}

