/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SimpleDiscreteSequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.results.Result;
import de.jstacs.utils.IntList;
import de.jstacs.utils.SafeOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import projects.talGA.TALENIndividual;
import projects.tals.TALgetterDiffSM;

public abstract class TALENFitnessFunction
implements FitnessFunction<DiscreteSequenceIndividual> {
    protected SafeOutputStream out = SafeOutputStream.getSafeOutputStream(null);
    protected TALgetterDiffSM fun;
    protected DataSet positives;
    protected int minDist;
    protected int maxDist;

    public TALENFitnessFunction(TALgetterDiffSM fun, DataSet positives, int minDist, int maxDist) throws CloneNotSupportedException {
        this.fun = fun.clone();
        this.positives = positives;
        this.minDist = minDist;
        this.maxDist = maxDist;
    }

    @Override
    public void setOutputStream(SafeOutputStream stream) {
        this.out = stream;
    }

    public int getTALENMatches(DiscreteSequenceIndividual individual, IntList matchPos1, IntList matchPos2, LinkedList<double[]> matchScores) throws Exception {
        TALENIndividual talen = (TALENIndividual)individual;
        SimpleDiscreteSequence first = talen.getFirstPart().getSequence();
        SimpleDiscreteSequence second = talen.getSecondPart().getSequence();
        ReferenceSequenceAnnotation anFirst = new ReferenceSequenceAnnotation("seq", first, new Result[0]);
        ReferenceSequenceAnnotation anSecond = new ReferenceSequenceAnnotation("seq", second, new Result[0]);
        double posScore = Double.NEGATIVE_INFINITY;
        double firstScore = Double.NEGATIVE_INFINITY;
        double secondScore = Double.NEGATIVE_INFINITY;
        int minNumMatches = Integer.MAX_VALUE;
        int i = 0;
        while (i < this.positives.getNumberOfElements()) {
            posScore = Double.NEGATIVE_INFINITY;
            firstScore = Double.NEGATIVE_INFINITY;
            secondScore = Double.NEGATIVE_INFINITY;
            Sequence seq = this.positives.getElementAt(i);
            int bestPos1 = -1;
            int bestPos2 = -1;
            double[][] temp = new double[2][seq.getLength()];
            Arrays.fill(temp[0], Double.NEGATIVE_INFINITY);
            Arrays.fill(temp[1], Double.NEGATIVE_INFINITY);
            int j = 0;
            while (j < seq.getLength() - first.getLength()) {
                temp[0][j] = this.fun.getLogScoreFor(seq.getSubSequence(j, first.getLength() + 1).annotate(false, anFirst));
                temp[1][j] = this.fun.getLogScoreFor(seq.getSubSequence(j, second.getLength() + 1).reverseComplement().annotate(false, anSecond));
                ++j;
            }
            j = 0;
            while (j < seq.getLength() - first.getLength() - second.getLength() - this.minDist) {
                int k = j + first.getLength() + this.minDist;
                while (k < seq.getLength() - second.getLength() && k <= j + first.getLength() + this.maxDist) {
                    if (temp[0][j] + temp[1][k] > posScore) {
                        posScore = temp[0][j] + temp[1][k];
                        firstScore = temp[0][j];
                        secondScore = temp[1][k];
                        bestPos1 = j;
                        bestPos2 = k;
                    }
                    ++k;
                }
                ++j;
            }
            Sequence sub = seq.getSubSequence(bestPos1, first.getLength() + 1);
            int numMatches = this.fun.getNumberOfMatches(sub, first);
            sub = seq.getSubSequence(bestPos2, second.getLength() + 1).reverseComplement();
            numMatches += this.fun.getNumberOfMatches(sub, second);
            if (!talen.isHomoDimer()) {
                seq = seq.reverseComplement();
                int j2 = 0;
                while (j2 < seq.getLength() - first.getLength()) {
                    temp[0][j2] = this.fun.getLogScoreFor(seq.getSubSequence(j2, first.getLength() + 1).annotate(false, anFirst));
                    temp[1][j2] = this.fun.getLogScoreFor(seq.getSubSequence(j2, second.getLength() + 1).reverseComplement().annotate(false, anSecond));
                    ++j2;
                }
                j2 = 0;
                while (j2 < seq.getLength() - first.getLength() - second.getLength() - this.minDist) {
                    int k = j2 + first.getLength() + this.minDist;
                    while (k < seq.getLength() - second.getLength() && k <= j2 + first.getLength() + this.maxDist) {
                        if (temp[0][j2] + temp[1][k] > posScore) {
                            posScore = temp[0][j2] + temp[1][k];
                            firstScore = temp[0][j2];
                            secondScore = temp[1][k];
                            bestPos1 = -j2 - 1;
                            bestPos2 = -k - 1;
                        }
                        ++k;
                    }
                    ++j2;
                }
                if (bestPos1 < 0) {
                    sub = seq.getSubSequence(-bestPos1 - 1, first.getLength() + 1);
                    int numMatches2 = this.fun.getNumberOfMatches(sub, first);
                    sub = seq.getSubSequence(-bestPos2 - 1, second.getLength() + 1).reverseComplement();
                    if ((numMatches2 += this.fun.getNumberOfMatches(sub, second)) > numMatches) {
                        numMatches = numMatches2;
                    }
                }
            }
            if (matchPos1 != null) {
                matchPos1.add(bestPos1);
            }
            if (matchPos2 != null) {
                matchPos2.add(bestPos2);
            }
            if (matchScores != null) {
                matchScores.add(new double[]{firstScore, secondScore, posScore});
            }
            if (numMatches < minNumMatches) {
                minNumMatches = numMatches;
            }
            ++i;
        }
        return minNumMatches;
    }
}

