/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.DiscreteSequenceEnumerator;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.utils.Time;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import projects.talGA.InfixMatchFinder;
import projects.talGA.MatchFinder;
import projects.tals.LimitedSortedList;
import projects.tals.ScanForTBSWeb;
import projects.tals.TALgetterDiffSM;

public class SpeedupTest {
    private static int[] powers;

    public static void main(String[] args) throws Exception {
        TALgetterDiffSM model = (TALgetterDiffSM)XMLParser.extractObjectForTags(FileManager.readInputStream(ScanForTBSWeb.class.getClassLoader().getResourceAsStream("projects/tals/talfinder_obg2_hyp_bg.xml")), "model");
        model.fix();
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        Sequence tal = Sequence.create(alphabetsRVD, "NS-NG-NS-HD-NI-NG-NN-NG-HD-NI-NN-N*-NI-NN-HD-NG-NI-NN", "-");
        int length = 9;
        double thresh = -20.0;
        DataSet ds = SpeedupTest.readFile("/Users/dev/Desktop/ChIP-seq/chromFa/all.chrom");
        Time t = Time.getTimeInstance(null);
        t.reset();
        InfixMatchFinder finder = new InfixMatchFinder(ds, length, model);
        LimitedSortedList<MatchFinder.Match> scs = finder.getScoresAbove(tal, thresh, 1000, true, false);
        System.out.println(t.getElapsedTime());
        System.out.println(scs.getLength());
        System.exit(1);
        powers = new int[length];
        int al = 4;
        SpeedupTest.powers[0] = 1;
        int i = 1;
        while (i < length) {
            SpeedupTest.powers[i] = powers[i - 1] * al;
            ++i;
        }
        int pl = powers[length - 1];
        t.reset();
        Object[] prep = SpeedupTest.prepare(model, tal, length, thresh);
        boolean[] bools = (boolean[])prep[1];
        double[] scores = (double[])prep[0];
        boolean[] bools2 = (boolean[])prep[3];
        double[] scores2 = (double[])prep[2];
        double rest = (Double)prep[4];
        int[] prevIdx = new int[bools.length];
        int[] addIdx = new int[al];
        int i2 = 0;
        while (i2 < prevIdx.length) {
            prevIdx[i2] = i2 / al;
            ++i2;
        }
        i2 = 0;
        while (i2 < addIdx.length) {
            addIdx[i2] = i2 * powers[length - 1];
            ++i2;
        }
        LimitedSortedList<int[]> list = new LimitedSortedList<int[]>(150000);
        System.out.println("scanning");
        long n = 0L;
        int order = Math.max(1, model.getOrder() + 1);
        int length2 = Math.min(length, tal.getLength() + 1 - length + order);
        int pl2 = powers[length2 - 1];
        int off2 = length + length2 - order;
        int ll2 = tal.getLength() - length - length2 + order + 1;
        boolean llb = ll2 > 0;
        double thresh2 = thresh - rest;
        int i3 = 0;
        while (i3 < ds.getNumberOfElements()) {
            Sequence seq = ds.getElementAt(i3);
            if (seq.getLength() > tal.getLength()) {
                int idx = SpeedupTest.getIndex(seq, 0, length);
                int idx3 = SpeedupTest.getIndex(seq, length - order - 1, length2);
                int end = seq.getLength() - tal.getLength();
                int j = 1;
                while (j < end + 1) {
                    double sc;
                    idx3 = idx3 / al + seq.discreteVal(j + length - 1 + length2 - order - 1) * pl2;
                    if (bools[idx] && bools2[idx3] && (sc = scores[idx] + scores2[idx3]) >= thresh2) {
                        if (llb) {
                            sc += model.getPartialLogScoreFor(tal, seq, j - 1, off2, ll2);
                        }
                        if (sc >= thresh && list.checkInsert(sc)) {
                            list.insert(sc, new int[]{i3, j - 1});
                        }
                    }
                    idx = idx / al + seq.discreteVal(j + length - 1) * pl;
                    ++j;
                }
            }
            ++i3;
        }
        System.out.println(n);
        System.out.println(t.getElapsedTime());
        System.out.println(list.getLength());
    }

    private static final int getIndex(Sequence seq, int off, int length) {
        int idx = 0;
        int i = 0;
        while (i < length) {
            idx += seq.discreteVal(off + i) * powers[i];
            ++i;
        }
        return idx;
    }

    private static Object[] prepare(TALgetterDiffSM model, Sequence tal, int length, double thresh) {
        double[] scs = new double[tal.getLength() + 1];
        model.getBestPossibleScore(tal, scs);
        double rest = 0.0;
        int i = length;
        while (i < scs.length) {
            rest += scs[i];
            ++i;
        }
        int al = (int)model.getAlphabetContainer().getAlphabetLengthAt(0);
        boolean[] bools = new boolean[(int)Math.pow(al, length)];
        double[] scores = new double[bools.length];
        DiscreteSequenceEnumerator dse = new DiscreteSequenceEnumerator(model.getAlphabetContainer(), length, false);
        int i2 = 0;
        while (dse.hasMoreElements()) {
            Object seq = dse.nextElement();
            double sc = model.getPartialLogScoreFor(tal, (Sequence)seq, 0, 0, length);
            bools[i2] = sc + rest >= thresh;
            scores[i2] = sc;
            ++i2;
        }
        rest = 0.0;
        int j = 0;
        while (j < length) {
            rest += scs[j];
            ++j;
        }
        int order = Math.max(model.getOrder() + 1, 1);
        int length2 = Math.min(length, tal.getLength() + 1 - length + order);
        double rest2 = 0.0;
        int j2 = length + length2 - order;
        while (j2 < scs.length) {
            rest += scs[j2];
            rest2 += scs[j2];
            ++j2;
        }
        tal = tal.getSubSequence(length - order);
        length = length2;
        boolean[] bools2 = new boolean[(int)Math.pow(al, length)];
        double[] scores2 = new double[bools2.length];
        dse = new DiscreteSequenceEnumerator(model.getAlphabetContainer(), length, false);
        i2 = 0;
        while (dse.hasMoreElements()) {
            Object seq = dse.nextElement();
            double sc = model.getPartialLogScoreFor(tal, (Sequence)seq, 0, order, length - order);
            bools2[i2] = sc + rest >= thresh;
            scores2[i2] = sc;
            ++i2;
        }
        return new Object[]{scores, bools, scores2, bools2, rest2};
    }

    public static DataSet readFile(String path) throws Exception {
        BufferedReader read = new BufferedReader(new FileReader(path));
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        Pattern acgt = Pattern.compile("[ACGT]+", 2);
        ArrayList<Sequence> seqs = new ArrayList<Sequence>();
        long l = 0L;
        StringBuffer line = new StringBuffer();
        String str = "";
        while ((str = read.readLine()) != null) {
            if (str.startsWith(">")) {
                if (line.length() <= 0) continue;
                seqs.add(new SparseSequence((AlphabetContainer)con, line.toString()));
                l += (long)line.length();
                line.delete(0, line.length());
                continue;
            }
            Matcher match = acgt.matcher(str);
            while (match.find()) {
                int start = match.start();
                int end = match.end();
                if (start > 0 || end < str.length()) {
                    if (start > 0 && line.length() > 0) {
                        seqs.add(new SparseSequence((AlphabetContainer)con, line.toString()));
                        l += (long)line.length();
                        line.delete(0, line.length());
                    }
                    line.append(str.substring(start, end));
                    if (end >= str.length() || line.length() <= 0) continue;
                    seqs.add(new SparseSequence((AlphabetContainer)con, line.toString()));
                    l += (long)line.length();
                    line.delete(0, line.length());
                    continue;
                }
                line.append(str);
            }
        }
        read.close();
        if (line.length() > 0) {
            seqs.add(new SparseSequence((AlphabetContainer)con, line.toString()));
            l += (long)line.length();
            line.delete(0, line.length());
        }
        str = null;
        System.out.println("total length: " + l);
        DataSet ds = new DataSet("", seqs);
        seqs.clear();
        return ds;
    }
}

