/*
 * Decompiled with CFR 0.152.
 */
package projects.talGA;

import de.jstacs.optimization.geneticAlgorithms.fitnessFunctions.FitnessFunction;
import de.jstacs.optimization.geneticAlgorithms.populations.individuals.DiscreteSequenceIndividual;
import de.jstacs.utils.SafeOutputStream;
import java.io.IOException;

public class RVDFitnessFunction
implements FitnessFunction<DiscreteSequenceIndividual> {
    private int[] positives;
    private int minRequired;
    private SafeOutputStream out;

    public RVDFitnessFunction(int[] positives, int minRequired) {
        this.positives = (int[])positives.clone();
        this.minRequired = minRequired;
        this.out = SafeOutputStream.getSafeOutputStream(null);
    }

    @Override
    public void setOutputStream(SafeOutputStream out) {
        this.out = out;
    }

    @Override
    public Double getFitness(DiscreteSequenceIndividual individual) throws IOException {
        double fitness = 0.0;
        int i = 0;
        while (i < individual.getDimension()) {
            int j = 0;
            while (j < this.positives.length) {
                if (this.positives[j] == individual.getValueAt(i)) {
                    fitness += 1.0;
                    break;
                }
                ++j;
            }
            ++i;
        }
        this.out.writeln("num strong: " + fitness);
        if (fitness < (double)this.minRequired) {
            fitness = 0.1;
        }
        return fitness / (double)individual.getDimension();
    }

    @Override
    public void reset() {
    }
}

